// Code generated by smithy-go-codegen DO NOT EDIT.

package rdb

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/rdb/types"
)

func (c *Client) PrepareDBInstanceForUpgrade(ctx context.Context, params *PrepareDBInstanceForUpgradeInput, optFns ...func(*Options)) (*PrepareDBInstanceForUpgradeOutput, error) {
	if params == nil {
		params = &PrepareDBInstanceForUpgradeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PrepareDBInstanceForUpgrade", params, optFns, c.addOperationPrepareDBInstanceForUpgradeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PrepareDBInstanceForUpgradeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PrepareDBInstanceForUpgradeInput struct {

	// This member is required.
	DBInstanceIdentifier *string

	TemporaryNiftyMasterPrivateAddress *string

	TemporaryNiftyReadReplicaPrivateAddresses *types.RequestTemporaryNiftyReadReplicaPrivateAddresses

	TemporaryNiftySlavePrivateAddress *string

	TemporaryNiftyVirtualPrivateAddress *string

	noSmithyDocumentSerde
}

type PrepareDBInstanceForUpgradeOutput struct {
	DBInstance *types.DBInstance

	ResponseMetadata *types.ResponseMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPrepareDBInstanceForUpgradeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpPrepareDBInstanceForUpgrade{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpPrepareDBInstanceForUpgrade{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPrepareDBInstanceForUpgradeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPrepareDBInstanceForUpgrade(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPrepareDBInstanceForUpgrade(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rdb",
		OperationName: "PrepareDBInstanceForUpgrade",
	}
}
