// Code generated by smithy-go-codegen DO NOT EDIT.

package nas

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"github.com/jmespath/go-jmespath"
	"github.com/nifcloud/nifcloud-sdk-go/service/nas/types"
	"strconv"
	"time"
)

func (c *Client) DescribeNASSecurityGroups(ctx context.Context, params *DescribeNASSecurityGroupsInput, optFns ...func(*Options)) (*DescribeNASSecurityGroupsOutput, error) {
	if params == nil {
		params = &DescribeNASSecurityGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeNASSecurityGroups", params, optFns, c.addOperationDescribeNASSecurityGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeNASSecurityGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeNASSecurityGroupsInput struct {
	NASSecurityGroupName *string

	noSmithyDocumentSerde
}

type DescribeNASSecurityGroupsOutput struct {
	NASSecurityGroups []types.NASSecurityGroupsOfDescribeNASSecurityGroups

	ResponseMetadata *types.ResponseMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeNASSecurityGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeNASSecurityGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeNASSecurityGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeNASSecurityGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeNASSecurityGroupsAPIClient is a client that implements the
// DescribeNASSecurityGroups operation.
type DescribeNASSecurityGroupsAPIClient interface {
	DescribeNASSecurityGroups(context.Context, *DescribeNASSecurityGroupsInput, ...func(*Options)) (*DescribeNASSecurityGroupsOutput, error)
}

var _ DescribeNASSecurityGroupsAPIClient = (*Client)(nil)

// NASSecurityGroupExistsWaiterOptions are waiter options for
// NASSecurityGroupExistsWaiter
type NASSecurityGroupExistsWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupExistsWaiter will use default minimum delay of 20 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupExistsWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupExistsWaiter defines the waiters for NASSecurityGroupExists
type NASSecurityGroupExistsWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupExistsWaiterOptions
}

// NewNASSecurityGroupExistsWaiter constructs a NASSecurityGroupExistsWaiter.
func NewNASSecurityGroupExistsWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupExistsWaiterOptions)) *NASSecurityGroupExistsWaiter {
	options := NASSecurityGroupExistsWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupExistsStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupExistsWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupExists waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *NASSecurityGroupExistsWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupExistsWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for NASSecurityGroupExists waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *NASSecurityGroupExistsWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupExistsWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupExists waiter")
}

func nASSecurityGroupExistsStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("length(NASSecurityGroups[]) > `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameter.NotFound.NASSecurityGroupName" == apiErr.ErrorCode() {
			return true, nil
		}
	}

	return true, nil
}

// NASSecurityGroupSecurityGroupsAuthorizedWaiterOptions are waiter options for
// NASSecurityGroupSecurityGroupsAuthorizedWaiter
type NASSecurityGroupSecurityGroupsAuthorizedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupSecurityGroupsAuthorizedWaiter will use default minimum delay of
	// 20 seconds. Note that MinDelay must resolve to a value lesser than or equal to
	// the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupSecurityGroupsAuthorizedWaiter will use default max
	// delay of 120 seconds. Note that MaxDelay must resolve to value greater than or
	// equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupSecurityGroupsAuthorizedWaiter defines the waiters for
// NASSecurityGroupSecurityGroupsAuthorized
type NASSecurityGroupSecurityGroupsAuthorizedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupSecurityGroupsAuthorizedWaiterOptions
}

// NewNASSecurityGroupSecurityGroupsAuthorizedWaiter constructs a
// NASSecurityGroupSecurityGroupsAuthorizedWaiter.
func NewNASSecurityGroupSecurityGroupsAuthorizedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupSecurityGroupsAuthorizedWaiterOptions)) *NASSecurityGroupSecurityGroupsAuthorizedWaiter {
	options := NASSecurityGroupSecurityGroupsAuthorizedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupSecurityGroupsAuthorizedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupSecurityGroupsAuthorizedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupSecurityGroupsAuthorized
// waiter. The maxWaitDur is the maximum wait duration the waiter will wait. The
// maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupSecurityGroupsAuthorizedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupSecurityGroupsAuthorizedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// NASSecurityGroupSecurityGroupsAuthorized waiter and returns the output of the
// successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupSecurityGroupsAuthorizedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupSecurityGroupsAuthorizedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupSecurityGroupsAuthorized waiter")
}

func nASSecurityGroupSecurityGroupsAuthorizedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("NASSecurityGroups[].SecurityGroups[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "authorized"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// NASSecurityGroupSecurityGroupsAuthFailedWaiterOptions are waiter options for
// NASSecurityGroupSecurityGroupsAuthFailedWaiter
type NASSecurityGroupSecurityGroupsAuthFailedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupSecurityGroupsAuthFailedWaiter will use default minimum delay of
	// 20 seconds. Note that MinDelay must resolve to a value lesser than or equal to
	// the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupSecurityGroupsAuthFailedWaiter will use default max
	// delay of 120 seconds. Note that MaxDelay must resolve to value greater than or
	// equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupSecurityGroupsAuthFailedWaiter defines the waiters for
// NASSecurityGroupSecurityGroupsAuthFailed
type NASSecurityGroupSecurityGroupsAuthFailedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupSecurityGroupsAuthFailedWaiterOptions
}

// NewNASSecurityGroupSecurityGroupsAuthFailedWaiter constructs a
// NASSecurityGroupSecurityGroupsAuthFailedWaiter.
func NewNASSecurityGroupSecurityGroupsAuthFailedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupSecurityGroupsAuthFailedWaiterOptions)) *NASSecurityGroupSecurityGroupsAuthFailedWaiter {
	options := NASSecurityGroupSecurityGroupsAuthFailedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupSecurityGroupsAuthFailedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupSecurityGroupsAuthFailedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupSecurityGroupsAuthFailed
// waiter. The maxWaitDur is the maximum wait duration the waiter will wait. The
// maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupSecurityGroupsAuthFailedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupSecurityGroupsAuthFailedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// NASSecurityGroupSecurityGroupsAuthFailed waiter and returns the output of the
// successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupSecurityGroupsAuthFailedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupSecurityGroupsAuthFailedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupSecurityGroupsAuthFailed waiter")
}

func nASSecurityGroupSecurityGroupsAuthFailedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("NASSecurityGroups[].SecurityGroups[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "auth-failed"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// NASSecurityGroupSecurityGroupsRevokeFailedWaiterOptions are waiter options for
// NASSecurityGroupSecurityGroupsRevokeFailedWaiter
type NASSecurityGroupSecurityGroupsRevokeFailedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupSecurityGroupsRevokeFailedWaiter will use default minimum delay
	// of 20 seconds. Note that MinDelay must resolve to a value lesser than or equal
	// to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupSecurityGroupsRevokeFailedWaiter will use default
	// max delay of 120 seconds. Note that MaxDelay must resolve to value greater than
	// or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupSecurityGroupsRevokeFailedWaiter defines the waiters for
// NASSecurityGroupSecurityGroupsRevokeFailed
type NASSecurityGroupSecurityGroupsRevokeFailedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupSecurityGroupsRevokeFailedWaiterOptions
}

// NewNASSecurityGroupSecurityGroupsRevokeFailedWaiter constructs a
// NASSecurityGroupSecurityGroupsRevokeFailedWaiter.
func NewNASSecurityGroupSecurityGroupsRevokeFailedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupSecurityGroupsRevokeFailedWaiterOptions)) *NASSecurityGroupSecurityGroupsRevokeFailedWaiter {
	options := NASSecurityGroupSecurityGroupsRevokeFailedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupSecurityGroupsRevokeFailedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupSecurityGroupsRevokeFailedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupSecurityGroupsRevokeFailed
// waiter. The maxWaitDur is the maximum wait duration the waiter will wait. The
// maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupSecurityGroupsRevokeFailedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupSecurityGroupsRevokeFailedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// NASSecurityGroupSecurityGroupsRevokeFailed waiter and returns the output of the
// successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupSecurityGroupsRevokeFailedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupSecurityGroupsRevokeFailedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupSecurityGroupsRevokeFailed waiter")
}

func nASSecurityGroupSecurityGroupsRevokeFailedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("NASSecurityGroups[].SecurityGroups[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "revoke-failed"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// NASSecurityGroupSecurityGroupsEmptiedWaiterOptions are waiter options for
// NASSecurityGroupSecurityGroupsEmptiedWaiter
type NASSecurityGroupSecurityGroupsEmptiedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupSecurityGroupsEmptiedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupSecurityGroupsEmptiedWaiter will use default max
	// delay of 120 seconds. Note that MaxDelay must resolve to value greater than or
	// equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupSecurityGroupsEmptiedWaiter defines the waiters for
// NASSecurityGroupSecurityGroupsEmptied
type NASSecurityGroupSecurityGroupsEmptiedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupSecurityGroupsEmptiedWaiterOptions
}

// NewNASSecurityGroupSecurityGroupsEmptiedWaiter constructs a
// NASSecurityGroupSecurityGroupsEmptiedWaiter.
func NewNASSecurityGroupSecurityGroupsEmptiedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupSecurityGroupsEmptiedWaiterOptions)) *NASSecurityGroupSecurityGroupsEmptiedWaiter {
	options := NASSecurityGroupSecurityGroupsEmptiedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupSecurityGroupsEmptiedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupSecurityGroupsEmptiedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupSecurityGroupsEmptied
// waiter. The maxWaitDur is the maximum wait duration the waiter will wait. The
// maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupSecurityGroupsEmptiedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupSecurityGroupsEmptiedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// NASSecurityGroupSecurityGroupsEmptied waiter and returns the output of the
// successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupSecurityGroupsEmptiedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupSecurityGroupsEmptiedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupSecurityGroupsEmptied waiter")
}

func nASSecurityGroupSecurityGroupsEmptiedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("length(NASSecurityGroups[0].SecurityGroups[]) == `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	return true, nil
}

// NASSecurityGroupIPRangesAuthorizedWaiterOptions are waiter options for
// NASSecurityGroupIPRangesAuthorizedWaiter
type NASSecurityGroupIPRangesAuthorizedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupIPRangesAuthorizedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupIPRangesAuthorizedWaiter will use default max delay
	// of 120 seconds. Note that MaxDelay must resolve to value greater than or equal
	// to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupIPRangesAuthorizedWaiter defines the waiters for
// NASSecurityGroupIPRangesAuthorized
type NASSecurityGroupIPRangesAuthorizedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupIPRangesAuthorizedWaiterOptions
}

// NewNASSecurityGroupIPRangesAuthorizedWaiter constructs a
// NASSecurityGroupIPRangesAuthorizedWaiter.
func NewNASSecurityGroupIPRangesAuthorizedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupIPRangesAuthorizedWaiterOptions)) *NASSecurityGroupIPRangesAuthorizedWaiter {
	options := NASSecurityGroupIPRangesAuthorizedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupIPRangesAuthorizedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupIPRangesAuthorizedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupIPRangesAuthorized waiter.
// The maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur
// is required and must be greater than zero.
func (w *NASSecurityGroupIPRangesAuthorizedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupIPRangesAuthorizedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for NASSecurityGroupIPRangesAuthorized
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *NASSecurityGroupIPRangesAuthorizedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupIPRangesAuthorizedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupIPRangesAuthorized waiter")
}

func nASSecurityGroupIPRangesAuthorizedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("NASSecurityGroups[].IPRanges[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "authorized"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// NASSecurityGroupIPRangesAuthFailedWaiterOptions are waiter options for
// NASSecurityGroupIPRangesAuthFailedWaiter
type NASSecurityGroupIPRangesAuthFailedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupIPRangesAuthFailedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupIPRangesAuthFailedWaiter will use default max delay
	// of 120 seconds. Note that MaxDelay must resolve to value greater than or equal
	// to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupIPRangesAuthFailedWaiter defines the waiters for
// NASSecurityGroupIPRangesAuthFailed
type NASSecurityGroupIPRangesAuthFailedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupIPRangesAuthFailedWaiterOptions
}

// NewNASSecurityGroupIPRangesAuthFailedWaiter constructs a
// NASSecurityGroupIPRangesAuthFailedWaiter.
func NewNASSecurityGroupIPRangesAuthFailedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupIPRangesAuthFailedWaiterOptions)) *NASSecurityGroupIPRangesAuthFailedWaiter {
	options := NASSecurityGroupIPRangesAuthFailedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupIPRangesAuthFailedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupIPRangesAuthFailedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupIPRangesAuthFailed waiter.
// The maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur
// is required and must be greater than zero.
func (w *NASSecurityGroupIPRangesAuthFailedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupIPRangesAuthFailedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for NASSecurityGroupIPRangesAuthFailed
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *NASSecurityGroupIPRangesAuthFailedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupIPRangesAuthFailedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupIPRangesAuthFailed waiter")
}

func nASSecurityGroupIPRangesAuthFailedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("NASSecurityGroups[].IPRanges[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "auth-failed"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// NASSecurityGroupIPRangesRevokeFailedWaiterOptions are waiter options for
// NASSecurityGroupIPRangesRevokeFailedWaiter
type NASSecurityGroupIPRangesRevokeFailedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupIPRangesRevokeFailedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupIPRangesRevokeFailedWaiter will use default max
	// delay of 120 seconds. Note that MaxDelay must resolve to value greater than or
	// equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupIPRangesRevokeFailedWaiter defines the waiters for
// NASSecurityGroupIPRangesRevokeFailed
type NASSecurityGroupIPRangesRevokeFailedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupIPRangesRevokeFailedWaiterOptions
}

// NewNASSecurityGroupIPRangesRevokeFailedWaiter constructs a
// NASSecurityGroupIPRangesRevokeFailedWaiter.
func NewNASSecurityGroupIPRangesRevokeFailedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupIPRangesRevokeFailedWaiterOptions)) *NASSecurityGroupIPRangesRevokeFailedWaiter {
	options := NASSecurityGroupIPRangesRevokeFailedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupIPRangesRevokeFailedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupIPRangesRevokeFailedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupIPRangesRevokeFailed waiter.
// The maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur
// is required and must be greater than zero.
func (w *NASSecurityGroupIPRangesRevokeFailedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupIPRangesRevokeFailedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// NASSecurityGroupIPRangesRevokeFailed waiter and returns the output of the
// successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *NASSecurityGroupIPRangesRevokeFailedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupIPRangesRevokeFailedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupIPRangesRevokeFailed waiter")
}

func nASSecurityGroupIPRangesRevokeFailedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("NASSecurityGroups[].IPRanges[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "revoke-failed"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// NASSecurityGroupIPRangesEmptiedWaiterOptions are waiter options for
// NASSecurityGroupIPRangesEmptiedWaiter
type NASSecurityGroupIPRangesEmptiedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupIPRangesEmptiedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupIPRangesEmptiedWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupIPRangesEmptiedWaiter defines the waiters for
// NASSecurityGroupIPRangesEmptied
type NASSecurityGroupIPRangesEmptiedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupIPRangesEmptiedWaiterOptions
}

// NewNASSecurityGroupIPRangesEmptiedWaiter constructs a
// NASSecurityGroupIPRangesEmptiedWaiter.
func NewNASSecurityGroupIPRangesEmptiedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupIPRangesEmptiedWaiterOptions)) *NASSecurityGroupIPRangesEmptiedWaiter {
	options := NASSecurityGroupIPRangesEmptiedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupIPRangesEmptiedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupIPRangesEmptiedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupIPRangesEmptied waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *NASSecurityGroupIPRangesEmptiedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupIPRangesEmptiedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for NASSecurityGroupIPRangesEmptied
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *NASSecurityGroupIPRangesEmptiedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupIPRangesEmptiedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupIPRangesEmptied waiter")
}

func nASSecurityGroupIPRangesEmptiedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("length(NASSecurityGroups[0].IPRanges[]) == `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	return true, nil
}

// NASSecurityGroupDeletedWaiterOptions are waiter options for
// NASSecurityGroupDeletedWaiter
type NASSecurityGroupDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// NASSecurityGroupDeletedWaiter will use default minimum delay of 20 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, NASSecurityGroupDeletedWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeNASSecurityGroupsInput, *DescribeNASSecurityGroupsOutput, error) (bool, error)
}

// NASSecurityGroupDeletedWaiter defines the waiters for NASSecurityGroupDeleted
type NASSecurityGroupDeletedWaiter struct {
	client DescribeNASSecurityGroupsAPIClient

	options NASSecurityGroupDeletedWaiterOptions
}

// NewNASSecurityGroupDeletedWaiter constructs a NASSecurityGroupDeletedWaiter.
func NewNASSecurityGroupDeletedWaiter(client DescribeNASSecurityGroupsAPIClient, optFns ...func(*NASSecurityGroupDeletedWaiterOptions)) *NASSecurityGroupDeletedWaiter {
	options := NASSecurityGroupDeletedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = nASSecurityGroupDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &NASSecurityGroupDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for NASSecurityGroupDeleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *NASSecurityGroupDeletedWaiter) Wait(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for NASSecurityGroupDeleted waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *NASSecurityGroupDeletedWaiter) WaitForOutput(ctx context.Context, params *DescribeNASSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*NASSecurityGroupDeletedWaiterOptions)) (*DescribeNASSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeNASSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for NASSecurityGroupDeleted waiter")
}

func nASSecurityGroupDeletedStateRetryable(ctx context.Context, input *DescribeNASSecurityGroupsInput, output *DescribeNASSecurityGroupsOutput, err error) (bool, error) {

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameter.NotFound.NASSecurityGroupName" == apiErr.ErrorCode() {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("length(NASSecurityGroups[]) > `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return true, nil
		}
	}

	return true, nil
}

func newServiceMetadataMiddleware_opDescribeNASSecurityGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "nas",
		OperationName: "DescribeNASSecurityGroups",
	}
}
