// Code generated by smithy-go-codegen DO NOT EDIT.

package devops

import (
	"bytes"
	"context"
	"fmt"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/devops/types"
)

type awsRestjson1_serializeOpAuthorizeFirewallRules struct {
}

func (*awsRestjson1_serializeOpAuthorizeFirewallRules) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAuthorizeFirewallRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeFirewallRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/firewallGroups/{FirewallGroupName}/rules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAuthorizeFirewallRulesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAuthorizeFirewallRulesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAuthorizeFirewallRulesInput(v *AuthorizeFirewallRulesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FirewallGroupName == nil || len(*v.FirewallGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FirewallGroupName must not be empty")}
	}
	if v.FirewallGroupName != nil {
		if err := encoder.SetURI("FirewallGroupName").String(*v.FirewallGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAuthorizeFirewallRulesInput(v *AuthorizeFirewallRulesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Rules != nil {
		ok := object.Key("rules")
		if err := awsRestjson1_serializeDocumentListOfRequestRules(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBackupRule struct {
}

func (*awsRestjson1_serializeOpCreateBackupRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackupRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackupRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/backupRules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackupRuleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackupRuleInput(v *CreateBackupRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackupRuleInput(v *CreateBackupRuleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupRuleName != nil {
		ok := object.Key("backupRuleName")
		ok.String(*v.BackupRuleName)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.InstanceId != nil {
		ok := object.Key("instanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateFirewallGroup struct {
}

func (*awsRestjson1_serializeOpCreateFirewallGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFirewallGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFirewallGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/firewallGroups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFirewallGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFirewallGroupInput(v *CreateFirewallGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFirewallGroupInput(v *CreateFirewallGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityZone) > 0 {
		ok := object.Key("availabilityZone")
		ok.String(string(v.AvailabilityZone))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FirewallGroupName != nil {
		ok := object.Key("firewallGroupName")
		ok.String(*v.FirewallGroupName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateInstance struct {
}

func (*awsRestjson1_serializeOpCreateInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateInstanceInput(v *CreateInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateInstanceInput(v *CreateInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityZone) > 0 {
		ok := object.Key("availabilityZone")
		ok.String(string(v.AvailabilityZone))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DiskSize != nil {
		ok := object.Key("diskSize")
		ok.Integer(*v.DiskSize)
	}

	if v.FirewallGroupName != nil {
		ok := object.Key("firewallGroupName")
		ok.String(*v.FirewallGroupName)
	}

	if v.InitialRootPassword != nil {
		ok := object.Key("initialRootPassword")
		ok.String(*v.InitialRootPassword)
	}

	if v.InstanceId != nil {
		ok := object.Key("instanceId")
		ok.String(*v.InstanceId)
	}

	if len(v.InstanceType) > 0 {
		ok := object.Key("instanceType")
		ok.String(string(v.InstanceType))
	}

	if v.NetworkConfig != nil {
		ok := object.Key("networkConfig")
		if err := awsRestjson1_serializeDocumentRequestNetworkConfig(v.NetworkConfig, ok); err != nil {
			return err
		}
	}

	if v.ObjectStorageConfig != nil {
		ok := object.Key("objectStorageConfig")
		if err := awsRestjson1_serializeDocumentRequestObjectStorageConfig(v.ObjectStorageConfig, ok); err != nil {
			return err
		}
	}

	if v.ParameterGroupName != nil {
		ok := object.Key("parameterGroupName")
		ok.String(*v.ParameterGroupName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateParameterGroup struct {
}

func (*awsRestjson1_serializeOpCreateParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/parameterGroups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateParameterGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateParameterGroupInput(v *CreateParameterGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateParameterGroupInput(v *CreateParameterGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ParameterGroupName != nil {
		ok := object.Key("parameterGroupName")
		ok.String(*v.ParameterGroupName)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackup struct {
}

func (*awsRestjson1_serializeOpDeleteBackup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/backups/{BackupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackupInput(v *DeleteBackupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupId == nil || len(*v.BackupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupId must not be empty")}
	}
	if v.BackupId != nil {
		if err := encoder.SetURI("BackupId").String(*v.BackupId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackupRule struct {
}

func (*awsRestjson1_serializeOpDeleteBackupRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackupRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/backupRules/{BackupRuleName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackupRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackupRuleInput(v *DeleteBackupRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupRuleName == nil || len(*v.BackupRuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupRuleName must not be empty")}
	}
	if v.BackupRuleName != nil {
		if err := encoder.SetURI("BackupRuleName").String(*v.BackupRuleName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFirewallGroup struct {
}

func (*awsRestjson1_serializeOpDeleteFirewallGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFirewallGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFirewallGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/firewallGroups/{FirewallGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFirewallGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFirewallGroupInput(v *DeleteFirewallGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FirewallGroupName == nil || len(*v.FirewallGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FirewallGroupName must not be empty")}
	}
	if v.FirewallGroupName != nil {
		if err := encoder.SetURI("FirewallGroupName").String(*v.FirewallGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInstance struct {
}

func (*awsRestjson1_serializeOpDeleteInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInstanceInput(v *DeleteInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteParameterGroup struct {
}

func (*awsRestjson1_serializeOpDeleteParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/parameterGroups/{ParameterGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteParameterGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteParameterGroupInput(v *DeleteParameterGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ParameterGroupName == nil || len(*v.ParameterGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ParameterGroupName must not be empty")}
	}
	if v.ParameterGroupName != nil {
		if err := encoder.SetURI("ParameterGroupName").String(*v.ParameterGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExtendDisk struct {
}

func (*awsRestjson1_serializeOpExtendDisk) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExtendDisk) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExtendDiskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}:extendDisk")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExtendDiskInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExtendDiskInput(v *ExtendDiskInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBackup struct {
}

func (*awsRestjson1_serializeOpGetBackup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/backups/{BackupId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackupInput(v *GetBackupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupId == nil || len(*v.BackupId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupId must not be empty")}
	}
	if v.BackupId != nil {
		if err := encoder.SetURI("BackupId").String(*v.BackupId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBackupRule struct {
}

func (*awsRestjson1_serializeOpGetBackupRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackupRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackupRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/backupRules/{BackupRuleName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackupRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackupRuleInput(v *GetBackupRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupRuleName == nil || len(*v.BackupRuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupRuleName must not be empty")}
	}
	if v.BackupRuleName != nil {
		if err := encoder.SetURI("BackupRuleName").String(*v.BackupRuleName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFirewallGroup struct {
}

func (*awsRestjson1_serializeOpGetFirewallGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFirewallGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFirewallGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/firewallGroups/{FirewallGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFirewallGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFirewallGroupInput(v *GetFirewallGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FirewallGroupName == nil || len(*v.FirewallGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FirewallGroupName must not be empty")}
	}
	if v.FirewallGroupName != nil {
		if err := encoder.SetURI("FirewallGroupName").String(*v.FirewallGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetInstance struct {
}

func (*awsRestjson1_serializeOpGetInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetInstanceInput(v *GetInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetInstanceMetrics struct {
}

func (*awsRestjson1_serializeOpGetInstanceMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetInstanceMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetInstanceMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}/metrics/{MetricsName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetInstanceMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetInstanceMetricsInput(v *GetInstanceMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(*v.EndTime)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	if v.MetricsName == nil || len(*v.MetricsName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MetricsName must not be empty")}
	}
	if v.MetricsName != nil {
		if err := encoder.SetURI("MetricsName").String(*v.MetricsName); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(*v.StartTime)
	}

	return nil
}

type awsRestjson1_serializeOpGetParameterGroup struct {
}

func (*awsRestjson1_serializeOpGetParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/parameterGroups/{ParameterGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetParameterGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetParameterGroupInput(v *GetParameterGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ParameterGroupName == nil || len(*v.ParameterGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ParameterGroupName must not be empty")}
	}
	if v.ParameterGroupName != nil {
		if err := encoder.SetURI("ParameterGroupName").String(*v.ParameterGroupName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBackupRules struct {
}

func (*awsRestjson1_serializeOpListBackupRules) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackupRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackupRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/backupRules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackupRulesInput(v *ListBackupRulesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpListBackups struct {
}

func (*awsRestjson1_serializeOpListBackups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/backups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackupsInput(v *ListBackupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpListFirewallGroups struct {
}

func (*awsRestjson1_serializeOpListFirewallGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFirewallGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFirewallGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/firewallGroups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFirewallGroupsInput(v *ListFirewallGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpListInstances struct {
}

func (*awsRestjson1_serializeOpListInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInstancesInput(v *ListInstancesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpListParameterGroups struct {
}

func (*awsRestjson1_serializeOpListParameterGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListParameterGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListParameterGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/parameterGroups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListParameterGroupsInput(v *ListParameterGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpRebootInstance struct {
}

func (*awsRestjson1_serializeOpRebootInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRebootInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RebootInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}:reboot")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRebootInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRebootInstanceInput(v *RebootInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRestoreInstance struct {
}

func (*awsRestjson1_serializeOpRestoreInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRestoreInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances:restore")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRestoreInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRestoreInstanceInput(v *RestoreInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRestoreInstanceInput(v *RestoreInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityZone) > 0 {
		ok := object.Key("availabilityZone")
		ok.String(string(v.AvailabilityZone))
	}

	if v.BackupId != nil {
		ok := object.Key("backupId")
		ok.String(*v.BackupId)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DiskSize != nil {
		ok := object.Key("diskSize")
		ok.Integer(*v.DiskSize)
	}

	if v.FirewallGroupName != nil {
		ok := object.Key("firewallGroupName")
		ok.String(*v.FirewallGroupName)
	}

	if v.InstanceId != nil {
		ok := object.Key("instanceId")
		ok.String(*v.InstanceId)
	}

	if len(v.InstanceType) > 0 {
		ok := object.Key("instanceType")
		ok.String(string(v.InstanceType))
	}

	if v.NetworkConfig != nil {
		ok := object.Key("networkConfig")
		if err := awsRestjson1_serializeDocumentRequestNetworkConfig(v.NetworkConfig, ok); err != nil {
			return err
		}
	}

	if v.ObjectStorageConfig != nil {
		ok := object.Key("objectStorageConfig")
		if err := awsRestjson1_serializeDocumentRequestObjectStorageConfigOfRestoreInstance(v.ObjectStorageConfig, ok); err != nil {
			return err
		}
	}

	if v.ParameterGroupName != nil {
		ok := object.Key("parameterGroupName")
		ok.String(*v.ParameterGroupName)
	}

	return nil
}

type awsRestjson1_serializeOpRevokeFirewallRules struct {
}

func (*awsRestjson1_serializeOpRevokeFirewallRules) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRevokeFirewallRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeFirewallRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/firewallGroups/{FirewallGroupName}/rules")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRevokeFirewallRulesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRevokeFirewallRulesInput(v *RevokeFirewallRulesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FirewallGroupName == nil || len(*v.FirewallGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FirewallGroupName must not be empty")}
	}
	if v.FirewallGroupName != nil {
		if err := encoder.SetURI("FirewallGroupName").String(*v.FirewallGroupName); err != nil {
			return err
		}
	}

	if v.Ids != nil {
		encoder.SetQuery("ids").String(*v.Ids)
	}

	return nil
}

type awsRestjson1_serializeOpSetupAlert struct {
}

func (*awsRestjson1_serializeOpSetupAlert) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetupAlert) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetupAlertInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}:setupAlert")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSetupAlertInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSetupAlertInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetupAlertInput(v *SetupAlertInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSetupAlertInput(v *SetupAlertInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.To != nil {
		ok := object.Key("to")
		ok.String(*v.To)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBackupRule struct {
}

func (*awsRestjson1_serializeOpUpdateBackupRule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBackupRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBackupRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/backupRules/{BackupRuleName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBackupRuleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBackupRuleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBackupRuleInput(v *UpdateBackupRuleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupRuleName == nil || len(*v.BackupRuleName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupRuleName must not be empty")}
	}
	if v.BackupRuleName != nil {
		if err := encoder.SetURI("BackupRuleName").String(*v.BackupRuleName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBackupRuleInput(v *UpdateBackupRuleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChangedBackupRuleName != nil {
		ok := object.Key("changedBackupRuleName")
		ok.String(*v.ChangedBackupRuleName)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFirewallGroup struct {
}

func (*awsRestjson1_serializeOpUpdateFirewallGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFirewallGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFirewallGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/firewallGroups/{FirewallGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFirewallGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFirewallGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFirewallGroupInput(v *UpdateFirewallGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FirewallGroupName == nil || len(*v.FirewallGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FirewallGroupName must not be empty")}
	}
	if v.FirewallGroupName != nil {
		if err := encoder.SetURI("FirewallGroupName").String(*v.FirewallGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFirewallGroupInput(v *UpdateFirewallGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChangedFirewallGroupName != nil {
		ok := object.Key("changedFirewallGroupName")
		ok.String(*v.ChangedFirewallGroupName)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInstance struct {
}

func (*awsRestjson1_serializeOpUpdateInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInstanceInput(v *UpdateInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateInstanceInput(v *UpdateInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FirewallGroupName != nil {
		ok := object.Key("firewallGroupName")
		ok.String(*v.FirewallGroupName)
	}

	if len(v.InstanceType) > 0 {
		ok := object.Key("instanceType")
		ok.String(string(v.InstanceType))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateNetworkInterface struct {
}

func (*awsRestjson1_serializeOpUpdateNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}:updateNetworkInterface")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateNetworkInterfaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateNetworkInterfaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateNetworkInterfaceInput(v *UpdateNetworkInterfaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateNetworkInterfaceInput(v *UpdateNetworkInterfaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkConfig != nil {
		ok := object.Key("networkConfig")
		if err := awsRestjson1_serializeDocumentRequestNetworkConfig(v.NetworkConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateParameterGroup struct {
}

func (*awsRestjson1_serializeOpUpdateParameterGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateParameterGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateParameterGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/parameterGroups/{ParameterGroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateParameterGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateParameterGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateParameterGroupInput(v *UpdateParameterGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ParameterGroupName == nil || len(*v.ParameterGroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ParameterGroupName must not be empty")}
	}
	if v.ParameterGroupName != nil {
		if err := encoder.SetURI("ParameterGroupName").String(*v.ParameterGroupName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateParameterGroupInput(v *UpdateParameterGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChangedParameterGroupName != nil {
		ok := object.Key("changedParameterGroupName")
		ok.String(*v.ChangedParameterGroupName)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Parameters != nil {
		ok := object.Key("parameters")
		if err := awsRestjson1_serializeDocumentRequestParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpgradeInstance struct {
}

func (*awsRestjson1_serializeOpUpgradeInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpgradeInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpgradeInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/instances/{InstanceId}:upgrade")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpgradeInstanceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpgradeInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpgradeInstanceInput(v *UpgradeInstanceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InstanceId == nil || len(*v.InstanceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member InstanceId must not be empty")}
	}
	if v.InstanceId != nil {
		if err := encoder.SetURI("InstanceId").String(*v.InstanceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpgradeInstanceInput(v *UpgradeInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GitlabVersion != nil {
		ok := object.Key("gitlabVersion")
		ok.String(*v.GitlabVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentListOfRequestRules(v []types.RequestRules, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRequestRules(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRequestBucketUseObjects(v *types.RequestBucketUseObjects, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerRegistry != nil {
		ok := object.Key("containerRegistry")
		ok.String(*v.ContainerRegistry)
	}

	if v.Lfs != nil {
		ok := object.Key("lfs")
		ok.String(*v.Lfs)
	}

	if v.Packages != nil {
		ok := object.Key("packages")
		ok.String(*v.Packages)
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestNetworkConfig(v *types.RequestNetworkConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkId != nil {
		ok := object.Key("networkId")
		ok.String(*v.NetworkId)
	}

	if v.PrivateAddress != nil {
		ok := object.Key("privateAddress")
		ok.String(*v.PrivateAddress)
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestObjectStorageConfig(v *types.RequestObjectStorageConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Account != nil {
		ok := object.Key("account")
		ok.String(*v.Account)
	}

	if len(v.Region) > 0 {
		ok := object.Key("region")
		ok.String(string(v.Region))
	}

	if v.RequestBucketUseObjects != nil {
		ok := object.Key("bucketUseObjects")
		if err := awsRestjson1_serializeDocumentRequestBucketUseObjects(v.RequestBucketUseObjects, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestObjectStorageConfigOfRestoreInstance(v *types.RequestObjectStorageConfigOfRestoreInstance, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Account != nil {
		ok := object.Key("account")
		ok.String(*v.Account)
	}

	if len(v.Region) > 0 {
		ok := object.Key("region")
		ok.String(string(v.Region))
	}

	if v.RequestBucketUseObjects != nil {
		ok := object.Key("bucketUseObjects")
		if err := awsRestjson1_serializeDocumentRequestBucketUseObjects(v.RequestBucketUseObjects, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestParameters(v *types.RequestParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GitlabEmailFrom != nil {
		ok := object.Key("gitlab_email_from")
		ok.String(*v.GitlabEmailFrom)
	}

	if v.GitlabEmailReplyTo != nil {
		ok := object.Key("gitlab_email_reply_to")
		ok.String(*v.GitlabEmailReplyTo)
	}

	if v.LdapEnabled != nil {
		ok := object.Key("ldap_enabled")
		ok.String(*v.LdapEnabled)
	}

	if v.LdapServersActiveDirectory != nil {
		ok := object.Key("ldap_servers_active_directory")
		ok.String(*v.LdapServersActiveDirectory)
	}

	if v.LdapServersActiveDirectory2 != nil {
		ok := object.Key("ldap_servers_active_directory_2")
		ok.String(*v.LdapServersActiveDirectory2)
	}

	if v.LdapServersActiveDirectory3 != nil {
		ok := object.Key("ldap_servers_active_directory_3")
		ok.String(*v.LdapServersActiveDirectory3)
	}

	if v.LdapServersActiveDirectory4 != nil {
		ok := object.Key("ldap_servers_active_directory_4")
		ok.String(*v.LdapServersActiveDirectory4)
	}

	if v.LdapServersActiveDirectory5 != nil {
		ok := object.Key("ldap_servers_active_directory_5")
		ok.String(*v.LdapServersActiveDirectory5)
	}

	if v.LdapServersAllowUsernameOrEmailLogin != nil {
		ok := object.Key("ldap_servers_allow_username_or_email_login")
		ok.String(*v.LdapServersAllowUsernameOrEmailLogin)
	}

	if v.LdapServersAllowUsernameOrEmailLogin2 != nil {
		ok := object.Key("ldap_servers_allow_username_or_email_login_2")
		ok.String(*v.LdapServersAllowUsernameOrEmailLogin2)
	}

	if v.LdapServersAllowUsernameOrEmailLogin3 != nil {
		ok := object.Key("ldap_servers_allow_username_or_email_login_3")
		ok.String(*v.LdapServersAllowUsernameOrEmailLogin3)
	}

	if v.LdapServersAllowUsernameOrEmailLogin4 != nil {
		ok := object.Key("ldap_servers_allow_username_or_email_login_4")
		ok.String(*v.LdapServersAllowUsernameOrEmailLogin4)
	}

	if v.LdapServersAllowUsernameOrEmailLogin5 != nil {
		ok := object.Key("ldap_servers_allow_username_or_email_login_5")
		ok.String(*v.LdapServersAllowUsernameOrEmailLogin5)
	}

	if v.LdapServersAttributesEmail != nil {
		ok := object.Key("ldap_servers_attributes_email")
		ok.String(*v.LdapServersAttributesEmail)
	}

	if v.LdapServersAttributesEmail2 != nil {
		ok := object.Key("ldap_servers_attributes_email_2")
		ok.String(*v.LdapServersAttributesEmail2)
	}

	if v.LdapServersAttributesEmail3 != nil {
		ok := object.Key("ldap_servers_attributes_email_3")
		ok.String(*v.LdapServersAttributesEmail3)
	}

	if v.LdapServersAttributesEmail4 != nil {
		ok := object.Key("ldap_servers_attributes_email_4")
		ok.String(*v.LdapServersAttributesEmail4)
	}

	if v.LdapServersAttributesEmail5 != nil {
		ok := object.Key("ldap_servers_attributes_email_5")
		ok.String(*v.LdapServersAttributesEmail5)
	}

	if v.LdapServersAttributesFirstName != nil {
		ok := object.Key("ldap_servers_attributes_first_name")
		ok.String(*v.LdapServersAttributesFirstName)
	}

	if v.LdapServersAttributesFirstName2 != nil {
		ok := object.Key("ldap_servers_attributes_first_name_2")
		ok.String(*v.LdapServersAttributesFirstName2)
	}

	if v.LdapServersAttributesFirstName3 != nil {
		ok := object.Key("ldap_servers_attributes_first_name_3")
		ok.String(*v.LdapServersAttributesFirstName3)
	}

	if v.LdapServersAttributesFirstName4 != nil {
		ok := object.Key("ldap_servers_attributes_first_name_4")
		ok.String(*v.LdapServersAttributesFirstName4)
	}

	if v.LdapServersAttributesFirstName5 != nil {
		ok := object.Key("ldap_servers_attributes_first_name_5")
		ok.String(*v.LdapServersAttributesFirstName5)
	}

	if v.LdapServersAttributesLastName != nil {
		ok := object.Key("ldap_servers_attributes_last_name")
		ok.String(*v.LdapServersAttributesLastName)
	}

	if v.LdapServersAttributesLastName2 != nil {
		ok := object.Key("ldap_servers_attributes_last_name_2")
		ok.String(*v.LdapServersAttributesLastName2)
	}

	if v.LdapServersAttributesLastName3 != nil {
		ok := object.Key("ldap_servers_attributes_last_name_3")
		ok.String(*v.LdapServersAttributesLastName3)
	}

	if v.LdapServersAttributesLastName4 != nil {
		ok := object.Key("ldap_servers_attributes_last_name_4")
		ok.String(*v.LdapServersAttributesLastName4)
	}

	if v.LdapServersAttributesLastName5 != nil {
		ok := object.Key("ldap_servers_attributes_last_name_5")
		ok.String(*v.LdapServersAttributesLastName5)
	}

	if v.LdapServersAttributesName != nil {
		ok := object.Key("ldap_servers_attributes_name")
		ok.String(*v.LdapServersAttributesName)
	}

	if v.LdapServersAttributesName2 != nil {
		ok := object.Key("ldap_servers_attributes_name_2")
		ok.String(*v.LdapServersAttributesName2)
	}

	if v.LdapServersAttributesName3 != nil {
		ok := object.Key("ldap_servers_attributes_name_3")
		ok.String(*v.LdapServersAttributesName3)
	}

	if v.LdapServersAttributesName4 != nil {
		ok := object.Key("ldap_servers_attributes_name_4")
		ok.String(*v.LdapServersAttributesName4)
	}

	if v.LdapServersAttributesName5 != nil {
		ok := object.Key("ldap_servers_attributes_name_5")
		ok.String(*v.LdapServersAttributesName5)
	}

	if v.LdapServersAttributesUsername != nil {
		ok := object.Key("ldap_servers_attributes_username")
		ok.String(*v.LdapServersAttributesUsername)
	}

	if v.LdapServersAttributesUsername2 != nil {
		ok := object.Key("ldap_servers_attributes_username_2")
		ok.String(*v.LdapServersAttributesUsername2)
	}

	if v.LdapServersAttributesUsername3 != nil {
		ok := object.Key("ldap_servers_attributes_username_3")
		ok.String(*v.LdapServersAttributesUsername3)
	}

	if v.LdapServersAttributesUsername4 != nil {
		ok := object.Key("ldap_servers_attributes_username_4")
		ok.String(*v.LdapServersAttributesUsername4)
	}

	if v.LdapServersAttributesUsername5 != nil {
		ok := object.Key("ldap_servers_attributes_username_5")
		ok.String(*v.LdapServersAttributesUsername5)
	}

	if v.LdapServersBase != nil {
		ok := object.Key("ldap_servers_base")
		ok.String(*v.LdapServersBase)
	}

	if v.LdapServersBase2 != nil {
		ok := object.Key("ldap_servers_base_2")
		ok.String(*v.LdapServersBase2)
	}

	if v.LdapServersBase3 != nil {
		ok := object.Key("ldap_servers_base_3")
		ok.String(*v.LdapServersBase3)
	}

	if v.LdapServersBase4 != nil {
		ok := object.Key("ldap_servers_base_4")
		ok.String(*v.LdapServersBase4)
	}

	if v.LdapServersBase5 != nil {
		ok := object.Key("ldap_servers_base_5")
		ok.String(*v.LdapServersBase5)
	}

	if v.LdapServersBindDn != nil {
		ok := object.Key("ldap_servers_bind_dn")
		ok.String(*v.LdapServersBindDn)
	}

	if v.LdapServersBindDn2 != nil {
		ok := object.Key("ldap_servers_bind_dn_2")
		ok.String(*v.LdapServersBindDn2)
	}

	if v.LdapServersBindDn3 != nil {
		ok := object.Key("ldap_servers_bind_dn_3")
		ok.String(*v.LdapServersBindDn3)
	}

	if v.LdapServersBindDn4 != nil {
		ok := object.Key("ldap_servers_bind_dn_4")
		ok.String(*v.LdapServersBindDn4)
	}

	if v.LdapServersBindDn5 != nil {
		ok := object.Key("ldap_servers_bind_dn_5")
		ok.String(*v.LdapServersBindDn5)
	}

	if v.LdapServersBlockAutoCreatedUsers != nil {
		ok := object.Key("ldap_servers_block_auto_created_users")
		ok.String(*v.LdapServersBlockAutoCreatedUsers)
	}

	if v.LdapServersBlockAutoCreatedUsers2 != nil {
		ok := object.Key("ldap_servers_block_auto_created_users_2")
		ok.String(*v.LdapServersBlockAutoCreatedUsers2)
	}

	if v.LdapServersBlockAutoCreatedUsers3 != nil {
		ok := object.Key("ldap_servers_block_auto_created_users_3")
		ok.String(*v.LdapServersBlockAutoCreatedUsers3)
	}

	if v.LdapServersBlockAutoCreatedUsers4 != nil {
		ok := object.Key("ldap_servers_block_auto_created_users_4")
		ok.String(*v.LdapServersBlockAutoCreatedUsers4)
	}

	if v.LdapServersBlockAutoCreatedUsers5 != nil {
		ok := object.Key("ldap_servers_block_auto_created_users_5")
		ok.String(*v.LdapServersBlockAutoCreatedUsers5)
	}

	if v.LdapServersEncryption != nil {
		ok := object.Key("ldap_servers_encryption")
		ok.String(*v.LdapServersEncryption)
	}

	if v.LdapServersEncryption2 != nil {
		ok := object.Key("ldap_servers_encryption_2")
		ok.String(*v.LdapServersEncryption2)
	}

	if v.LdapServersEncryption3 != nil {
		ok := object.Key("ldap_servers_encryption_3")
		ok.String(*v.LdapServersEncryption3)
	}

	if v.LdapServersEncryption4 != nil {
		ok := object.Key("ldap_servers_encryption_4")
		ok.String(*v.LdapServersEncryption4)
	}

	if v.LdapServersEncryption5 != nil {
		ok := object.Key("ldap_servers_encryption_5")
		ok.String(*v.LdapServersEncryption5)
	}

	if v.LdapServersHost != nil {
		ok := object.Key("ldap_servers_host")
		ok.String(*v.LdapServersHost)
	}

	if v.LdapServersHost2 != nil {
		ok := object.Key("ldap_servers_host_2")
		ok.String(*v.LdapServersHost2)
	}

	if v.LdapServersHost3 != nil {
		ok := object.Key("ldap_servers_host_3")
		ok.String(*v.LdapServersHost3)
	}

	if v.LdapServersHost4 != nil {
		ok := object.Key("ldap_servers_host_4")
		ok.String(*v.LdapServersHost4)
	}

	if v.LdapServersHost5 != nil {
		ok := object.Key("ldap_servers_host_5")
		ok.String(*v.LdapServersHost5)
	}

	if v.LdapServersLabel != nil {
		ok := object.Key("ldap_servers_label")
		ok.String(*v.LdapServersLabel)
	}

	if v.LdapServersLabel2 != nil {
		ok := object.Key("ldap_servers_label_2")
		ok.String(*v.LdapServersLabel2)
	}

	if v.LdapServersLabel3 != nil {
		ok := object.Key("ldap_servers_label_3")
		ok.String(*v.LdapServersLabel3)
	}

	if v.LdapServersLabel4 != nil {
		ok := object.Key("ldap_servers_label_4")
		ok.String(*v.LdapServersLabel4)
	}

	if v.LdapServersLabel5 != nil {
		ok := object.Key("ldap_servers_label_5")
		ok.String(*v.LdapServersLabel5)
	}

	if v.LdapServersLowercaseUsernames != nil {
		ok := object.Key("ldap_servers_lowercase_usernames")
		ok.String(*v.LdapServersLowercaseUsernames)
	}

	if v.LdapServersLowercaseUsernames2 != nil {
		ok := object.Key("ldap_servers_lowercase_usernames_2")
		ok.String(*v.LdapServersLowercaseUsernames2)
	}

	if v.LdapServersLowercaseUsernames3 != nil {
		ok := object.Key("ldap_servers_lowercase_usernames_3")
		ok.String(*v.LdapServersLowercaseUsernames3)
	}

	if v.LdapServersLowercaseUsernames4 != nil {
		ok := object.Key("ldap_servers_lowercase_usernames_4")
		ok.String(*v.LdapServersLowercaseUsernames4)
	}

	if v.LdapServersLowercaseUsernames5 != nil {
		ok := object.Key("ldap_servers_lowercase_usernames_5")
		ok.String(*v.LdapServersLowercaseUsernames5)
	}

	if v.LdapServersName != nil {
		ok := object.Key("ldap_servers_name")
		ok.String(*v.LdapServersName)
	}

	if v.LdapServersName2 != nil {
		ok := object.Key("ldap_servers_name_2")
		ok.String(*v.LdapServersName2)
	}

	if v.LdapServersName3 != nil {
		ok := object.Key("ldap_servers_name_3")
		ok.String(*v.LdapServersName3)
	}

	if v.LdapServersName4 != nil {
		ok := object.Key("ldap_servers_name_4")
		ok.String(*v.LdapServersName4)
	}

	if v.LdapServersName5 != nil {
		ok := object.Key("ldap_servers_name_5")
		ok.String(*v.LdapServersName5)
	}

	if v.LdapServersPassword != nil {
		ok := object.Key("ldap_servers_password")
		ok.String(*v.LdapServersPassword)
	}

	if v.LdapServersPassword2 != nil {
		ok := object.Key("ldap_servers_password_2")
		ok.String(*v.LdapServersPassword2)
	}

	if v.LdapServersPassword3 != nil {
		ok := object.Key("ldap_servers_password_3")
		ok.String(*v.LdapServersPassword3)
	}

	if v.LdapServersPassword4 != nil {
		ok := object.Key("ldap_servers_password_4")
		ok.String(*v.LdapServersPassword4)
	}

	if v.LdapServersPassword5 != nil {
		ok := object.Key("ldap_servers_password_5")
		ok.String(*v.LdapServersPassword5)
	}

	if v.LdapServersPort != nil {
		ok := object.Key("ldap_servers_port")
		ok.String(*v.LdapServersPort)
	}

	if v.LdapServersPort2 != nil {
		ok := object.Key("ldap_servers_port_2")
		ok.String(*v.LdapServersPort2)
	}

	if v.LdapServersPort3 != nil {
		ok := object.Key("ldap_servers_port_3")
		ok.String(*v.LdapServersPort3)
	}

	if v.LdapServersPort4 != nil {
		ok := object.Key("ldap_servers_port_4")
		ok.String(*v.LdapServersPort4)
	}

	if v.LdapServersPort5 != nil {
		ok := object.Key("ldap_servers_port_5")
		ok.String(*v.LdapServersPort5)
	}

	if v.LdapServersTimeout != nil {
		ok := object.Key("ldap_servers_timeout")
		ok.String(*v.LdapServersTimeout)
	}

	if v.LdapServersTimeout2 != nil {
		ok := object.Key("ldap_servers_timeout_2")
		ok.String(*v.LdapServersTimeout2)
	}

	if v.LdapServersTimeout3 != nil {
		ok := object.Key("ldap_servers_timeout_3")
		ok.String(*v.LdapServersTimeout3)
	}

	if v.LdapServersTimeout4 != nil {
		ok := object.Key("ldap_servers_timeout_4")
		ok.String(*v.LdapServersTimeout4)
	}

	if v.LdapServersTimeout5 != nil {
		ok := object.Key("ldap_servers_timeout_5")
		ok.String(*v.LdapServersTimeout5)
	}

	if v.LdapServersUid != nil {
		ok := object.Key("ldap_servers_uid")
		ok.String(*v.LdapServersUid)
	}

	if v.LdapServersUid2 != nil {
		ok := object.Key("ldap_servers_uid_2")
		ok.String(*v.LdapServersUid2)
	}

	if v.LdapServersUid3 != nil {
		ok := object.Key("ldap_servers_uid_3")
		ok.String(*v.LdapServersUid3)
	}

	if v.LdapServersUid4 != nil {
		ok := object.Key("ldap_servers_uid_4")
		ok.String(*v.LdapServersUid4)
	}

	if v.LdapServersUid5 != nil {
		ok := object.Key("ldap_servers_uid_5")
		ok.String(*v.LdapServersUid5)
	}

	if v.LdapServersUserFilter != nil {
		ok := object.Key("ldap_servers_user_filter")
		ok.String(*v.LdapServersUserFilter)
	}

	if v.LdapServersUserFilter2 != nil {
		ok := object.Key("ldap_servers_user_filter_2")
		ok.String(*v.LdapServersUserFilter2)
	}

	if v.LdapServersUserFilter3 != nil {
		ok := object.Key("ldap_servers_user_filter_3")
		ok.String(*v.LdapServersUserFilter3)
	}

	if v.LdapServersUserFilter4 != nil {
		ok := object.Key("ldap_servers_user_filter_4")
		ok.String(*v.LdapServersUserFilter4)
	}

	if v.LdapServersUserFilter5 != nil {
		ok := object.Key("ldap_servers_user_filter_5")
		ok.String(*v.LdapServersUserFilter5)
	}

	if v.LdapServersVerifyCertificates != nil {
		ok := object.Key("ldap_servers_verify_certificates")
		ok.String(*v.LdapServersVerifyCertificates)
	}

	if v.LdapServersVerifyCertificates2 != nil {
		ok := object.Key("ldap_servers_verify_certificates_2")
		ok.String(*v.LdapServersVerifyCertificates2)
	}

	if v.LdapServersVerifyCertificates3 != nil {
		ok := object.Key("ldap_servers_verify_certificates_3")
		ok.String(*v.LdapServersVerifyCertificates3)
	}

	if v.LdapServersVerifyCertificates4 != nil {
		ok := object.Key("ldap_servers_verify_certificates_4")
		ok.String(*v.LdapServersVerifyCertificates4)
	}

	if v.LdapServersVerifyCertificates5 != nil {
		ok := object.Key("ldap_servers_verify_certificates_5")
		ok.String(*v.LdapServersVerifyCertificates5)
	}

	if v.OmniauthAllowSingleSignOn != nil {
		ok := object.Key("omniauth_allow_single_sign_on")
		ok.String(*v.OmniauthAllowSingleSignOn)
	}

	if v.OmniauthAutoLinkSamlUser != nil {
		ok := object.Key("omniauth_auto_link_saml_user")
		ok.String(*v.OmniauthAutoLinkSamlUser)
	}

	if v.OmniauthAutoSignInWithProvider != nil {
		ok := object.Key("omniauth_auto_sign_in_with_provider")
		ok.String(*v.OmniauthAutoSignInWithProvider)
	}

	if v.OmniauthBlockAutoCreatedUsers != nil {
		ok := object.Key("omniauth_block_auto_created_users")
		ok.String(*v.OmniauthBlockAutoCreatedUsers)
	}

	if v.OmniauthProvidersSamlAdminGroups != nil {
		ok := object.Key("omniauth_providers_saml_admin_groups")
		ok.String(*v.OmniauthProvidersSamlAdminGroups)
	}

	if v.OmniauthProvidersSamlAdminGroups2 != nil {
		ok := object.Key("omniauth_providers_saml_admin_groups_2")
		ok.String(*v.OmniauthProvidersSamlAdminGroups2)
	}

	if v.OmniauthProvidersSamlAdminGroups3 != nil {
		ok := object.Key("omniauth_providers_saml_admin_groups_3")
		ok.String(*v.OmniauthProvidersSamlAdminGroups3)
	}

	if v.OmniauthProvidersSamlAdminGroups4 != nil {
		ok := object.Key("omniauth_providers_saml_admin_groups_4")
		ok.String(*v.OmniauthProvidersSamlAdminGroups4)
	}

	if v.OmniauthProvidersSamlAdminGroups5 != nil {
		ok := object.Key("omniauth_providers_saml_admin_groups_5")
		ok.String(*v.OmniauthProvidersSamlAdminGroups5)
	}

	if v.OmniauthProvidersSamlAssertionConsumerServiceUrl != nil {
		ok := object.Key("omniauth_providers_saml_assertion_consumer_service_url")
		ok.String(*v.OmniauthProvidersSamlAssertionConsumerServiceUrl)
	}

	if v.OmniauthProvidersSamlAssertionConsumerServiceUrl2 != nil {
		ok := object.Key("omniauth_providers_saml_assertion_consumer_service_url_2")
		ok.String(*v.OmniauthProvidersSamlAssertionConsumerServiceUrl2)
	}

	if v.OmniauthProvidersSamlAssertionConsumerServiceUrl3 != nil {
		ok := object.Key("omniauth_providers_saml_assertion_consumer_service_url_3")
		ok.String(*v.OmniauthProvidersSamlAssertionConsumerServiceUrl3)
	}

	if v.OmniauthProvidersSamlAssertionConsumerServiceUrl4 != nil {
		ok := object.Key("omniauth_providers_saml_assertion_consumer_service_url_4")
		ok.String(*v.OmniauthProvidersSamlAssertionConsumerServiceUrl4)
	}

	if v.OmniauthProvidersSamlAssertionConsumerServiceUrl5 != nil {
		ok := object.Key("omniauth_providers_saml_assertion_consumer_service_url_5")
		ok.String(*v.OmniauthProvidersSamlAssertionConsumerServiceUrl5)
	}

	if v.OmniauthProvidersSamlAuditorGroups != nil {
		ok := object.Key("omniauth_providers_saml_auditor_groups")
		ok.String(*v.OmniauthProvidersSamlAuditorGroups)
	}

	if v.OmniauthProvidersSamlAuditorGroups2 != nil {
		ok := object.Key("omniauth_providers_saml_auditor_groups_2")
		ok.String(*v.OmniauthProvidersSamlAuditorGroups2)
	}

	if v.OmniauthProvidersSamlAuditorGroups3 != nil {
		ok := object.Key("omniauth_providers_saml_auditor_groups_3")
		ok.String(*v.OmniauthProvidersSamlAuditorGroups3)
	}

	if v.OmniauthProvidersSamlAuditorGroups4 != nil {
		ok := object.Key("omniauth_providers_saml_auditor_groups_4")
		ok.String(*v.OmniauthProvidersSamlAuditorGroups4)
	}

	if v.OmniauthProvidersSamlAuditorGroups5 != nil {
		ok := object.Key("omniauth_providers_saml_auditor_groups_5")
		ok.String(*v.OmniauthProvidersSamlAuditorGroups5)
	}

	if v.OmniauthProvidersSamlExternalGroups != nil {
		ok := object.Key("omniauth_providers_saml_external_groups")
		ok.String(*v.OmniauthProvidersSamlExternalGroups)
	}

	if v.OmniauthProvidersSamlExternalGroups2 != nil {
		ok := object.Key("omniauth_providers_saml_external_groups_2")
		ok.String(*v.OmniauthProvidersSamlExternalGroups2)
	}

	if v.OmniauthProvidersSamlExternalGroups3 != nil {
		ok := object.Key("omniauth_providers_saml_external_groups_3")
		ok.String(*v.OmniauthProvidersSamlExternalGroups3)
	}

	if v.OmniauthProvidersSamlExternalGroups4 != nil {
		ok := object.Key("omniauth_providers_saml_external_groups_4")
		ok.String(*v.OmniauthProvidersSamlExternalGroups4)
	}

	if v.OmniauthProvidersSamlExternalGroups5 != nil {
		ok := object.Key("omniauth_providers_saml_external_groups_5")
		ok.String(*v.OmniauthProvidersSamlExternalGroups5)
	}

	if v.OmniauthProvidersSamlGroupsAttribute != nil {
		ok := object.Key("omniauth_providers_saml_groups_attribute")
		ok.String(*v.OmniauthProvidersSamlGroupsAttribute)
	}

	if v.OmniauthProvidersSamlGroupsAttribute2 != nil {
		ok := object.Key("omniauth_providers_saml_groups_attribute_2")
		ok.String(*v.OmniauthProvidersSamlGroupsAttribute2)
	}

	if v.OmniauthProvidersSamlGroupsAttribute3 != nil {
		ok := object.Key("omniauth_providers_saml_groups_attribute_3")
		ok.String(*v.OmniauthProvidersSamlGroupsAttribute3)
	}

	if v.OmniauthProvidersSamlGroupsAttribute4 != nil {
		ok := object.Key("omniauth_providers_saml_groups_attribute_4")
		ok.String(*v.OmniauthProvidersSamlGroupsAttribute4)
	}

	if v.OmniauthProvidersSamlGroupsAttribute5 != nil {
		ok := object.Key("omniauth_providers_saml_groups_attribute_5")
		ok.String(*v.OmniauthProvidersSamlGroupsAttribute5)
	}

	if v.OmniauthProvidersSamlIdpCertFingerprint != nil {
		ok := object.Key("omniauth_providers_saml_idp_cert_fingerprint")
		ok.String(*v.OmniauthProvidersSamlIdpCertFingerprint)
	}

	if v.OmniauthProvidersSamlIdpCertFingerprint2 != nil {
		ok := object.Key("omniauth_providers_saml_idp_cert_fingerprint_2")
		ok.String(*v.OmniauthProvidersSamlIdpCertFingerprint2)
	}

	if v.OmniauthProvidersSamlIdpCertFingerprint3 != nil {
		ok := object.Key("omniauth_providers_saml_idp_cert_fingerprint_3")
		ok.String(*v.OmniauthProvidersSamlIdpCertFingerprint3)
	}

	if v.OmniauthProvidersSamlIdpCertFingerprint4 != nil {
		ok := object.Key("omniauth_providers_saml_idp_cert_fingerprint_4")
		ok.String(*v.OmniauthProvidersSamlIdpCertFingerprint4)
	}

	if v.OmniauthProvidersSamlIdpCertFingerprint5 != nil {
		ok := object.Key("omniauth_providers_saml_idp_cert_fingerprint_5")
		ok.String(*v.OmniauthProvidersSamlIdpCertFingerprint5)
	}

	if v.OmniauthProvidersSamlIdpSsoTargetUrl != nil {
		ok := object.Key("omniauth_providers_saml_idp_sso_target_url")
		ok.String(*v.OmniauthProvidersSamlIdpSsoTargetUrl)
	}

	if v.OmniauthProvidersSamlIdpSsoTargetUrl2 != nil {
		ok := object.Key("omniauth_providers_saml_idp_sso_target_url_2")
		ok.String(*v.OmniauthProvidersSamlIdpSsoTargetUrl2)
	}

	if v.OmniauthProvidersSamlIdpSsoTargetUrl3 != nil {
		ok := object.Key("omniauth_providers_saml_idp_sso_target_url_3")
		ok.String(*v.OmniauthProvidersSamlIdpSsoTargetUrl3)
	}

	if v.OmniauthProvidersSamlIdpSsoTargetUrl4 != nil {
		ok := object.Key("omniauth_providers_saml_idp_sso_target_url_4")
		ok.String(*v.OmniauthProvidersSamlIdpSsoTargetUrl4)
	}

	if v.OmniauthProvidersSamlIdpSsoTargetUrl5 != nil {
		ok := object.Key("omniauth_providers_saml_idp_sso_target_url_5")
		ok.String(*v.OmniauthProvidersSamlIdpSsoTargetUrl5)
	}

	if v.OmniauthProvidersSamlIssuer != nil {
		ok := object.Key("omniauth_providers_saml_issuer")
		ok.String(*v.OmniauthProvidersSamlIssuer)
	}

	if v.OmniauthProvidersSamlIssuer2 != nil {
		ok := object.Key("omniauth_providers_saml_issuer_2")
		ok.String(*v.OmniauthProvidersSamlIssuer2)
	}

	if v.OmniauthProvidersSamlIssuer3 != nil {
		ok := object.Key("omniauth_providers_saml_issuer_3")
		ok.String(*v.OmniauthProvidersSamlIssuer3)
	}

	if v.OmniauthProvidersSamlIssuer4 != nil {
		ok := object.Key("omniauth_providers_saml_issuer_4")
		ok.String(*v.OmniauthProvidersSamlIssuer4)
	}

	if v.OmniauthProvidersSamlIssuer5 != nil {
		ok := object.Key("omniauth_providers_saml_issuer_5")
		ok.String(*v.OmniauthProvidersSamlIssuer5)
	}

	if v.OmniauthProvidersSamlLabel != nil {
		ok := object.Key("omniauth_providers_saml_label")
		ok.String(*v.OmniauthProvidersSamlLabel)
	}

	if v.OmniauthProvidersSamlLabel2 != nil {
		ok := object.Key("omniauth_providers_saml_label_2")
		ok.String(*v.OmniauthProvidersSamlLabel2)
	}

	if v.OmniauthProvidersSamlLabel3 != nil {
		ok := object.Key("omniauth_providers_saml_label_3")
		ok.String(*v.OmniauthProvidersSamlLabel3)
	}

	if v.OmniauthProvidersSamlLabel4 != nil {
		ok := object.Key("omniauth_providers_saml_label_4")
		ok.String(*v.OmniauthProvidersSamlLabel4)
	}

	if v.OmniauthProvidersSamlLabel5 != nil {
		ok := object.Key("omniauth_providers_saml_label_5")
		ok.String(*v.OmniauthProvidersSamlLabel5)
	}

	if v.OmniauthProvidersSamlName != nil {
		ok := object.Key("omniauth_providers_saml_name")
		ok.String(*v.OmniauthProvidersSamlName)
	}

	if v.OmniauthProvidersSamlName2 != nil {
		ok := object.Key("omniauth_providers_saml_name_2")
		ok.String(*v.OmniauthProvidersSamlName2)
	}

	if v.OmniauthProvidersSamlName3 != nil {
		ok := object.Key("omniauth_providers_saml_name_3")
		ok.String(*v.OmniauthProvidersSamlName3)
	}

	if v.OmniauthProvidersSamlName4 != nil {
		ok := object.Key("omniauth_providers_saml_name_4")
		ok.String(*v.OmniauthProvidersSamlName4)
	}

	if v.OmniauthProvidersSamlName5 != nil {
		ok := object.Key("omniauth_providers_saml_name_5")
		ok.String(*v.OmniauthProvidersSamlName5)
	}

	if v.OmniauthProvidersSamlNameIdentifierFormat != nil {
		ok := object.Key("omniauth_providers_saml_name_identifier_format")
		ok.String(*v.OmniauthProvidersSamlNameIdentifierFormat)
	}

	if v.OmniauthProvidersSamlNameIdentifierFormat2 != nil {
		ok := object.Key("omniauth_providers_saml_name_identifier_format_2")
		ok.String(*v.OmniauthProvidersSamlNameIdentifierFormat2)
	}

	if v.OmniauthProvidersSamlNameIdentifierFormat3 != nil {
		ok := object.Key("omniauth_providers_saml_name_identifier_format_3")
		ok.String(*v.OmniauthProvidersSamlNameIdentifierFormat3)
	}

	if v.OmniauthProvidersSamlNameIdentifierFormat4 != nil {
		ok := object.Key("omniauth_providers_saml_name_identifier_format_4")
		ok.String(*v.OmniauthProvidersSamlNameIdentifierFormat4)
	}

	if v.OmniauthProvidersSamlNameIdentifierFormat5 != nil {
		ok := object.Key("omniauth_providers_saml_name_identifier_format_5")
		ok.String(*v.OmniauthProvidersSamlNameIdentifierFormat5)
	}

	if v.OmniauthProvidersSamlRequiredGroups != nil {
		ok := object.Key("omniauth_providers_saml_required_groups")
		ok.String(*v.OmniauthProvidersSamlRequiredGroups)
	}

	if v.OmniauthProvidersSamlRequiredGroups2 != nil {
		ok := object.Key("omniauth_providers_saml_required_groups_2")
		ok.String(*v.OmniauthProvidersSamlRequiredGroups2)
	}

	if v.OmniauthProvidersSamlRequiredGroups3 != nil {
		ok := object.Key("omniauth_providers_saml_required_groups_3")
		ok.String(*v.OmniauthProvidersSamlRequiredGroups3)
	}

	if v.OmniauthProvidersSamlRequiredGroups4 != nil {
		ok := object.Key("omniauth_providers_saml_required_groups_4")
		ok.String(*v.OmniauthProvidersSamlRequiredGroups4)
	}

	if v.OmniauthProvidersSamlRequiredGroups5 != nil {
		ok := object.Key("omniauth_providers_saml_required_groups_5")
		ok.String(*v.OmniauthProvidersSamlRequiredGroups5)
	}

	if v.SmtpPassword != nil {
		ok := object.Key("smtp_password")
		ok.String(*v.SmtpPassword)
	}

	if v.SmtpUserName != nil {
		ok := object.Key("smtp_user_name")
		ok.String(*v.SmtpUserName)
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestRules(v *types.RequestRules, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CidrIp) > 0 {
		ok := object.Key("cidrIp")
		ok.String(string(v.CidrIp))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}
