// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) SetFilterForLoadBalancer(ctx context.Context, params *SetFilterForLoadBalancerInput, optFns ...func(*Options)) (*SetFilterForLoadBalancerOutput, error) {
	if params == nil {
		params = &SetFilterForLoadBalancerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SetFilterForLoadBalancer", params, optFns, c.addOperationSetFilterForLoadBalancerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SetFilterForLoadBalancerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SetFilterForLoadBalancerInput struct {

	// This member is required.
	InstancePort *int32

	// This member is required.
	LoadBalancerName *string

	// This member is required.
	LoadBalancerPort *int32

	FilterType types.FilterTypeOfSetFilterForLoadBalancerRequest

	IPAddresses *types.ListOfRequestIPAddresses

	noSmithyDocumentSerde
}

type SetFilterForLoadBalancerOutput struct {
	ResponseMetadata *types.ResponseMetadata

	SetFilterForLoadBalancerResult *types.SetFilterForLoadBalancerResult

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSetFilterForLoadBalancerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpSetFilterForLoadBalancer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpSetFilterForLoadBalancer{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpSetFilterForLoadBalancerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSetFilterForLoadBalancer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSetFilterForLoadBalancer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SetFilterForLoadBalancer",
	}
}
