// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) NiftyUpdateAutoScalingGroup(ctx context.Context, params *NiftyUpdateAutoScalingGroupInput, optFns ...func(*Options)) (*NiftyUpdateAutoScalingGroupOutput, error) {
	if params == nil {
		params = &NiftyUpdateAutoScalingGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NiftyUpdateAutoScalingGroup", params, optFns, c.addOperationNiftyUpdateAutoScalingGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NiftyUpdateAutoScalingGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NiftyUpdateAutoScalingGroupInput struct {

	// This member is required.
	AutoScalingGroupName *string

	// This member is required.
	ChangeInCapacity *int32

	// This member is required.
	MaxSize *int32

	// This member is required.
	MinSize *int32

	// This member is required.
	ScaleoutCondition types.ScaleoutConditionOfNiftyUpdateAutoScalingGroupRequest

	// This member is required.
	ScalingTrigger []types.RequestScalingTriggerOfNiftyUpdateAutoScalingGroup

	AutoScalingGroupNameUpdate *string

	DefaultCooldown *int32

	Description *string

	ImageId *string

	InstanceLifecycleLimit *int32

	InstanceType types.InstanceTypeOfNiftyUpdateAutoScalingGroupRequest

	LoadBalancers []types.RequestLoadBalancersOfNiftyUpdateAutoScalingGroup

	Scaleout *int32

	ScalingSchedule []types.RequestScalingScheduleOfNiftyUpdateAutoScalingGroup

	SecurityGroup []string

	noSmithyDocumentSerde
}

type NiftyUpdateAutoScalingGroupOutput struct {
	RequestId *string

	Return *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNiftyUpdateAutoScalingGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpNiftyUpdateAutoScalingGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpNiftyUpdateAutoScalingGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpNiftyUpdateAutoScalingGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNiftyUpdateAutoScalingGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opNiftyUpdateAutoScalingGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "NiftyUpdateAutoScalingGroup",
	}
}
