// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) NiftyDescribeVpnGatewayActivities(ctx context.Context, params *NiftyDescribeVpnGatewayActivitiesInput, optFns ...func(*Options)) (*NiftyDescribeVpnGatewayActivitiesOutput, error) {
	if params == nil {
		params = &NiftyDescribeVpnGatewayActivitiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NiftyDescribeVpnGatewayActivities", params, optFns, c.addOperationNiftyDescribeVpnGatewayActivitiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NiftyDescribeVpnGatewayActivitiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NiftyDescribeVpnGatewayActivitiesInput struct {
	NiftyVpnGatewayName *string

	VpnGatewayId *string

	noSmithyDocumentSerde
}

type NiftyDescribeVpnGatewayActivitiesOutput struct {
	AnalyzeResultSet []types.AnalyzeResultSet

	Log *string

	NiftyVpnGatewayName *string

	RequestId *string

	VpnGatewayId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNiftyDescribeVpnGatewayActivitiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpNiftyDescribeVpnGatewayActivities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpNiftyDescribeVpnGatewayActivities{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNiftyDescribeVpnGatewayActivities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opNiftyDescribeVpnGatewayActivities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "NiftyDescribeVpnGatewayActivities",
	}
}
