// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) NiftyCreateElasticLoadBalancer(ctx context.Context, params *NiftyCreateElasticLoadBalancerInput, optFns ...func(*Options)) (*NiftyCreateElasticLoadBalancerOutput, error) {
	if params == nil {
		params = &NiftyCreateElasticLoadBalancerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NiftyCreateElasticLoadBalancer", params, optFns, c.addOperationNiftyCreateElasticLoadBalancerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NiftyCreateElasticLoadBalancerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NiftyCreateElasticLoadBalancerInput struct {

	// This member is required.
	AvailabilityZones *types.ListOfRequestAvailabilityZones

	// This member is required.
	Listeners *types.ListOfRequestListenersOfNiftyCreateElasticLoadBalancer

	AccountingType types.AccountingTypeOfNiftyCreateElasticLoadBalancerRequest

	ElasticLoadBalancerName *string

	NetworkInterface []types.RequestNetworkInterfaceOfNiftyCreateElasticLoadBalancer

	NetworkVolume *int32

	noSmithyDocumentSerde
}

type NiftyCreateElasticLoadBalancerOutput struct {
	NiftyCreateElasticLoadBalancerResult *types.NiftyCreateElasticLoadBalancerResult

	ResponseMetadata *types.ResponseMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNiftyCreateElasticLoadBalancerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpNiftyCreateElasticLoadBalancer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpNiftyCreateElasticLoadBalancer{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpNiftyCreateElasticLoadBalancerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNiftyCreateElasticLoadBalancer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opNiftyCreateElasticLoadBalancer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "NiftyCreateElasticLoadBalancer",
	}
}
