// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) NiftyCreateAutoScalingGroup(ctx context.Context, params *NiftyCreateAutoScalingGroupInput, optFns ...func(*Options)) (*NiftyCreateAutoScalingGroupOutput, error) {
	if params == nil {
		params = &NiftyCreateAutoScalingGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NiftyCreateAutoScalingGroup", params, optFns, c.addOperationNiftyCreateAutoScalingGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NiftyCreateAutoScalingGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NiftyCreateAutoScalingGroupInput struct {

	// This member is required.
	AutoScalingGroupName *string

	// This member is required.
	ChangeInCapacity *int32

	// This member is required.
	ImageId *string

	// This member is required.
	MaxSize *int32

	// This member is required.
	MinSize *int32

	// This member is required.
	ScaleoutCondition types.ScaleoutConditionOfNiftyCreateAutoScalingGroupRequest

	// This member is required.
	ScalingTrigger []types.RequestScalingTrigger

	DefaultCooldown *int32

	Description *string

	InstanceLifecycleLimit *int32

	InstanceType types.InstanceTypeOfNiftyCreateAutoScalingGroupRequest

	LoadBalancers []types.RequestLoadBalancersOfNiftyCreateAutoScalingGroup

	Scaleout *int32

	ScalingSchedule []types.RequestScalingSchedule

	SecurityGroup []string

	noSmithyDocumentSerde
}

type NiftyCreateAutoScalingGroupOutput struct {
	RequestId *string

	Return *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNiftyCreateAutoScalingGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpNiftyCreateAutoScalingGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpNiftyCreateAutoScalingGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpNiftyCreateAutoScalingGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNiftyCreateAutoScalingGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opNiftyCreateAutoScalingGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "NiftyCreateAutoScalingGroup",
	}
}
