// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) DescribeUsage(ctx context.Context, params *DescribeUsageInput, optFns ...func(*Options)) (*DescribeUsageOutput, error) {
	if params == nil {
		params = &DescribeUsageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeUsage", params, optFns, c.addOperationDescribeUsageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeUsageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeUsageInput struct {
	IsCharge *bool

	Region *string

	YearMonth *string

	noSmithyDocumentSerde
}

type DescribeUsageOutput struct {
	AutoScaleInfo *types.AutoScaleInfo

	ChargeDetailInfo *types.ChargeDetailInfo

	CopyInfo *types.CopyInfoOfDescribeUsage

	ElasticIpInfo *types.ElasticIpInfo

	ElasticLoadBalancerInfo *types.ElasticLoadBalancerInfo

	ExtraChargeInfo *types.ExtraChargeInfo

	ImageInfo *types.ImageInfo

	InstanceBackupInfo *types.InstanceBackupInfo

	InstanceInfo *types.InstanceInfo

	InternetVpnInfo *types.InternetVpnInfo

	LicenseInfo *types.LicenseInfo

	LiveMigrationInfo *types.LiveMigrationInfo

	LoadBalancerInfo *types.LoadBalancerInfo

	MultiAccountInfo *types.MultiAccountInfo

	MultiIpAddressInfo *types.MultiIpAddressInfo

	NetworkInfo *types.NetworkInfo

	NetworkInterfaceInfo *types.NetworkInterfaceInfo

	OptionCommonInfo []types.OptionCommonInfo

	OptionInfo []types.OptionInfo

	OsOptionChargeInfo *types.OsOptionChargeInfo

	PatternAuthInfo *types.PatternAuthInfo

	PremiumSupportInfo *types.PremiumSupportInfo

	PrivateLanInfo *types.PrivateLanInfo

	PrivateNetworkInfo *types.PrivateNetworkInfo

	RemoteAccessVpnGatewayInfo *types.RemoteAccessVpnGatewayInfo

	RequestId *string

	RouterInfo *types.RouterInfo

	SecurityGroupInfo *types.SecurityGroupInfoOfDescribeUsage

	SnapshotInfo *types.SnapshotInfo

	SslCertInfo *types.SslCertInfo

	VolumeInfo *types.VolumeInfo

	VpnGatewayInfo *types.VpnGatewayInfo

	YearMonth *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeUsageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeUsage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeUsage{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeUsage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeUsage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeUsage",
	}
}
