// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"github.com/jmespath/go-jmespath"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
	"strconv"
	"time"
)

func (c *Client) DescribeRemoteAccessVpnGateways(ctx context.Context, params *DescribeRemoteAccessVpnGatewaysInput, optFns ...func(*Options)) (*DescribeRemoteAccessVpnGatewaysOutput, error) {
	if params == nil {
		params = &DescribeRemoteAccessVpnGatewaysInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeRemoteAccessVpnGateways", params, optFns, c.addOperationDescribeRemoteAccessVpnGatewaysMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeRemoteAccessVpnGatewaysOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeRemoteAccessVpnGatewaysInput struct {
	RemoteAccessVpnGatewayId []string

	noSmithyDocumentSerde
}

type DescribeRemoteAccessVpnGatewaysOutput struct {
	RemoteAccessVpnGatewaySet []types.RemoteAccessVpnGatewaySetOfDescribeRemoteAccessVpnGateways

	RequestId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeRemoteAccessVpnGatewaysMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeRemoteAccessVpnGateways{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeRemoteAccessVpnGateways{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeRemoteAccessVpnGateways(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeRemoteAccessVpnGatewaysAPIClient is a client that implements the
// DescribeRemoteAccessVpnGateways operation.
type DescribeRemoteAccessVpnGatewaysAPIClient interface {
	DescribeRemoteAccessVpnGateways(context.Context, *DescribeRemoteAccessVpnGatewaysInput, ...func(*Options)) (*DescribeRemoteAccessVpnGatewaysOutput, error)
}

var _ DescribeRemoteAccessVpnGatewaysAPIClient = (*Client)(nil)

// RemoteAccessVpnGatewayExistsWaiterOptions are waiter options for
// RemoteAccessVpnGatewayExistsWaiter
type RemoteAccessVpnGatewayExistsWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// RemoteAccessVpnGatewayExistsWaiter will use default minimum delay of 20 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, RemoteAccessVpnGatewayExistsWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeRemoteAccessVpnGatewaysInput, *DescribeRemoteAccessVpnGatewaysOutput, error) (bool, error)
}

// RemoteAccessVpnGatewayExistsWaiter defines the waiters for
// RemoteAccessVpnGatewayExists
type RemoteAccessVpnGatewayExistsWaiter struct {
	client DescribeRemoteAccessVpnGatewaysAPIClient

	options RemoteAccessVpnGatewayExistsWaiterOptions
}

// NewRemoteAccessVpnGatewayExistsWaiter constructs a
// RemoteAccessVpnGatewayExistsWaiter.
func NewRemoteAccessVpnGatewayExistsWaiter(client DescribeRemoteAccessVpnGatewaysAPIClient, optFns ...func(*RemoteAccessVpnGatewayExistsWaiterOptions)) *RemoteAccessVpnGatewayExistsWaiter {
	options := RemoteAccessVpnGatewayExistsWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = remoteAccessVpnGatewayExistsStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &RemoteAccessVpnGatewayExistsWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for RemoteAccessVpnGatewayExists waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *RemoteAccessVpnGatewayExistsWaiter) Wait(ctx context.Context, params *DescribeRemoteAccessVpnGatewaysInput, maxWaitDur time.Duration, optFns ...func(*RemoteAccessVpnGatewayExistsWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for RemoteAccessVpnGatewayExists waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *RemoteAccessVpnGatewayExistsWaiter) WaitForOutput(ctx context.Context, params *DescribeRemoteAccessVpnGatewaysInput, maxWaitDur time.Duration, optFns ...func(*RemoteAccessVpnGatewayExistsWaiterOptions)) (*DescribeRemoteAccessVpnGatewaysOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeRemoteAccessVpnGateways(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for RemoteAccessVpnGatewayExists waiter")
}

func remoteAccessVpnGatewayExistsStateRetryable(ctx context.Context, input *DescribeRemoteAccessVpnGatewaysInput, output *DescribeRemoteAccessVpnGatewaysOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("length(RemoteAccessVpnGatewaySet[]) > `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameterNotFound.RemoteAccessVpnGatewayId" == apiErr.ErrorCode() {
			return true, nil
		}
	}

	return true, nil
}

// RemoteAccessVpnGatewayAvailableWaiterOptions are waiter options for
// RemoteAccessVpnGatewayAvailableWaiter
type RemoteAccessVpnGatewayAvailableWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// RemoteAccessVpnGatewayAvailableWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, RemoteAccessVpnGatewayAvailableWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeRemoteAccessVpnGatewaysInput, *DescribeRemoteAccessVpnGatewaysOutput, error) (bool, error)
}

// RemoteAccessVpnGatewayAvailableWaiter defines the waiters for
// RemoteAccessVpnGatewayAvailable
type RemoteAccessVpnGatewayAvailableWaiter struct {
	client DescribeRemoteAccessVpnGatewaysAPIClient

	options RemoteAccessVpnGatewayAvailableWaiterOptions
}

// NewRemoteAccessVpnGatewayAvailableWaiter constructs a
// RemoteAccessVpnGatewayAvailableWaiter.
func NewRemoteAccessVpnGatewayAvailableWaiter(client DescribeRemoteAccessVpnGatewaysAPIClient, optFns ...func(*RemoteAccessVpnGatewayAvailableWaiterOptions)) *RemoteAccessVpnGatewayAvailableWaiter {
	options := RemoteAccessVpnGatewayAvailableWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = remoteAccessVpnGatewayAvailableStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &RemoteAccessVpnGatewayAvailableWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for RemoteAccessVpnGatewayAvailable waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *RemoteAccessVpnGatewayAvailableWaiter) Wait(ctx context.Context, params *DescribeRemoteAccessVpnGatewaysInput, maxWaitDur time.Duration, optFns ...func(*RemoteAccessVpnGatewayAvailableWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for RemoteAccessVpnGatewayAvailable
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *RemoteAccessVpnGatewayAvailableWaiter) WaitForOutput(ctx context.Context, params *DescribeRemoteAccessVpnGatewaysInput, maxWaitDur time.Duration, optFns ...func(*RemoteAccessVpnGatewayAvailableWaiterOptions)) (*DescribeRemoteAccessVpnGatewaysOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeRemoteAccessVpnGateways(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for RemoteAccessVpnGatewayAvailable waiter")
}

func remoteAccessVpnGatewayAvailableStateRetryable(ctx context.Context, input *DescribeRemoteAccessVpnGatewaysInput, output *DescribeRemoteAccessVpnGatewaysOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("RemoteAccessVpnGatewaySet[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "available"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// RemoteAccessVpnGatewayDeletedWaiterOptions are waiter options for
// RemoteAccessVpnGatewayDeletedWaiter
type RemoteAccessVpnGatewayDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// RemoteAccessVpnGatewayDeletedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, RemoteAccessVpnGatewayDeletedWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeRemoteAccessVpnGatewaysInput, *DescribeRemoteAccessVpnGatewaysOutput, error) (bool, error)
}

// RemoteAccessVpnGatewayDeletedWaiter defines the waiters for
// RemoteAccessVpnGatewayDeleted
type RemoteAccessVpnGatewayDeletedWaiter struct {
	client DescribeRemoteAccessVpnGatewaysAPIClient

	options RemoteAccessVpnGatewayDeletedWaiterOptions
}

// NewRemoteAccessVpnGatewayDeletedWaiter constructs a
// RemoteAccessVpnGatewayDeletedWaiter.
func NewRemoteAccessVpnGatewayDeletedWaiter(client DescribeRemoteAccessVpnGatewaysAPIClient, optFns ...func(*RemoteAccessVpnGatewayDeletedWaiterOptions)) *RemoteAccessVpnGatewayDeletedWaiter {
	options := RemoteAccessVpnGatewayDeletedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = remoteAccessVpnGatewayDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &RemoteAccessVpnGatewayDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for RemoteAccessVpnGatewayDeleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *RemoteAccessVpnGatewayDeletedWaiter) Wait(ctx context.Context, params *DescribeRemoteAccessVpnGatewaysInput, maxWaitDur time.Duration, optFns ...func(*RemoteAccessVpnGatewayDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for RemoteAccessVpnGatewayDeleted
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *RemoteAccessVpnGatewayDeletedWaiter) WaitForOutput(ctx context.Context, params *DescribeRemoteAccessVpnGatewaysInput, maxWaitDur time.Duration, optFns ...func(*RemoteAccessVpnGatewayDeletedWaiterOptions)) (*DescribeRemoteAccessVpnGatewaysOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeRemoteAccessVpnGateways(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for RemoteAccessVpnGatewayDeleted waiter")
}

func remoteAccessVpnGatewayDeletedStateRetryable(ctx context.Context, input *DescribeRemoteAccessVpnGatewaysInput, output *DescribeRemoteAccessVpnGatewaysOutput, err error) (bool, error) {

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameterNotFound.RemoteAccessVpnGatewayId" == apiErr.ErrorCode() {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("length(RemoteAccessVpnGatewaySet[]) == `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	return true, nil
}

func newServiceMetadataMiddleware_opDescribeRemoteAccessVpnGateways(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeRemoteAccessVpnGateways",
	}
}
