// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) CreateMultiIpAddressGroup(ctx context.Context, params *CreateMultiIpAddressGroupInput, optFns ...func(*Options)) (*CreateMultiIpAddressGroupOutput, error) {
	if params == nil {
		params = &CreateMultiIpAddressGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMultiIpAddressGroup", params, optFns, c.addOperationCreateMultiIpAddressGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMultiIpAddressGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMultiIpAddressGroupInput struct {

	// This member is required.
	IpAddressCount *int32

	// This member is required.
	MultiIpAddressGroupName *string

	// This member is required.
	Placement *types.RequestPlacementOfCreateMultiIpAddressGroup

	Description *string

	noSmithyDocumentSerde
}

type CreateMultiIpAddressGroupOutput struct {
	MultiIpAddressGroup *types.MultiIpAddressGroupOfCreateMultiIpAddressGroup

	RequestId *string

	Return *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMultiIpAddressGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpCreateMultiIpAddressGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCreateMultiIpAddressGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateMultiIpAddressGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMultiIpAddressGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateMultiIpAddressGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMultiIpAddressGroup",
	}
}
