// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) CopyFromBackupInstance(ctx context.Context, params *CopyFromBackupInstanceInput, optFns ...func(*Options)) (*CopyFromBackupInstanceOutput, error) {
	if params == nil {
		params = &CopyFromBackupInstanceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CopyFromBackupInstance", params, optFns, c.addOperationCopyFromBackupInstanceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CopyFromBackupInstanceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CopyFromBackupInstanceInput struct {

	// This member is required.
	BackupInstanceUniqueId *string

	AccountingType types.AccountingTypeOfCopyFromBackupInstanceRequest

	Description *string

	DisableApiTermination *bool

	InstanceId *string

	InstanceType types.InstanceTypeOfCopyFromBackupInstanceRequest

	NetworkInterface []types.RequestNetworkInterfaceOfCopyFromBackupInstance

	SecurityGroup []string

	noSmithyDocumentSerde
}

type CopyFromBackupInstanceOutput struct {
	GroupSet []types.GroupSet

	Instance *types.Instance

	OwnerId *string

	RequestId *string

	ReservationId *string

	Return *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCopyFromBackupInstanceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpCopyFromBackupInstance{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCopyFromBackupInstance{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCopyFromBackupInstanceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCopyFromBackupInstance(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCopyFromBackupInstance(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CopyFromBackupInstance",
	}
}
