/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.tools.DateUtils;
import com.nifty.cloud.sdk.vpngateway.model.Attachment;
import com.nifty.cloud.sdk.vpngateway.model.BackupInformation;
import com.nifty.cloud.sdk.vpngateway.model.NetworkInterfaceSet;
import com.nifty.cloud.sdk.vpngateway.model.Tag;
import com.nifty.cloud.sdk.vpngateway.model.VersionInformation;
import com.nifty.cloud.sdk.vpngateway.model.VpnGateway;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * VpnGatewaySetType変換クラス。<br />
 * このクラスはレスポンスXMLのvpnGatewaySet要素からVpnGatewayクラスのリストを生成します。
 */
public class VpnGatewaySetConverter implements Converter {

	private static final String ELEMENT_VPN_GATEWAY_ID = "vpnGatewayId";
	private static final String ELEMENT_NIFTY_VPN_GATEWAY_NAME = "niftyVpnGatewayName";
	private static final String ELEMENT_STATE = "state";
	private static final String ELEMENT_TYPE = "type";
	private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";
	private static final String ELEMENT_ATTACHMENTS = "attachments";
	private static final String ELEMENT_TAG_SET = "tagSet";
	private static final String ELEMENT_NIFTY_VPN_GATEWAY_TYPE = "niftyVpnGatewayType";
	private static final String ELEMENT_NIFTY_REDUNDANCY = "niftyRedundancy";
	private static final String ELEMENT_NIFTY_VPN_GATEWAY_DESCRIPTION = "niftyVpnGatewayDescription";
	private static final String ELEMENT_ACCOUNTING_TYPE = "accountingType";
	private static final String ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE = "nextMonthAccountingType";
	private static final String ELEMENT_VERSION_INFORMATION = "versionInformation";
	private static final String ELEMENT_NETWORK_INTERFACE_SET = "networkInterfaceSet";
	private static final String ELEMENT_BACKUP_INFORMATION = "backupInformation";
	private static final String ELEMENT_GROUP_SET = "groupSet";
	private static final String ELEMENT_ROUTE_TABLE_ID = "routeTableId";
	private static final String ELEMENT_ROUTE_TABLE_ASSOCIATION_ID = "routeTableAssociationId";
	private static final String ELEMENT_CREATED_TIME = "createdTime";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * vpnGatewaySetをList<VpnGateway>クラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<VpnGateway>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<VpnGateway> vpnGateways = new ArrayList<VpnGateway>();
		Converter attachmentsConverter = new AttachmentsConverter();
		Converter tagSetConverter = new TagSetConverter();
		Converter versionInformationConverter = new VersionInformationConverter();
		Converter networkInterfaceSetConverter = new NetworkInterfaceSetConverter();
		Converter backupInformationConverter = new BackupInformationConverter();
		Converter groupSetConverter = new GroupSetConverter();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();
			VpnGateway vpnGateway = new VpnGateway();

			while (reader.hasMoreChildren()) {
				reader.moveDown();

				name = reader.getNodeName();
				if (name.equals(ELEMENT_VPN_GATEWAY_ID)) {
					vpnGateway.setVpnGatewayId(reader.getValue());
				} else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_NAME)) {
					vpnGateway.setNiftyVpnGatewayName(reader.getValue());
				} else if (name.equals(ELEMENT_STATE)) {
					vpnGateway.setState(reader.getValue());
				} else if (name.equals(ELEMENT_TYPE)) {
					vpnGateway.setType(reader.getValue());
				} else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
					vpnGateway.setAvailabilityZone(reader.getValue());
				} else if (name.equals(ELEMENT_ATTACHMENTS)) {
					vpnGateway.setAttachments((List<Attachment>) attachmentsConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_TAG_SET)) {
					vpnGateway.setTagSet((List<Tag>) tagSetConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_TYPE)) {
					vpnGateway.setNiftyVpnGatewayType(reader.getValue());
				} else if (name.equals(ELEMENT_NIFTY_REDUNDANCY)) {
					vpnGateway.setNiftyRedundancy(Boolean.valueOf(reader.getValue()));
				} else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_DESCRIPTION)) {
					vpnGateway.setNiftyVpnGatewayDescription(reader.getValue());
				} else if (name.equals(ELEMENT_ACCOUNTING_TYPE)) {
					vpnGateway.setAccountingType(reader.getValue());
				} else if (name.equals(ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE)) {
					vpnGateway.setNextMonthAccountingType(reader.getValue());
				} else if (name.equals(ELEMENT_VERSION_INFORMATION)) {
					vpnGateway.setVersionInformation((VersionInformation) versionInformationConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_NETWORK_INTERFACE_SET)) {
					vpnGateway.setNetworkInterfaces((List<NetworkInterfaceSet>) networkInterfaceSetConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_BACKUP_INFORMATION)) {
					vpnGateway.setBackupInformation((BackupInformation) backupInformationConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_GROUP_SET)) {
					vpnGateway.setGroupIds((List<String>) groupSetConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_ROUTE_TABLE_ID)) {
					vpnGateway.setRouteTableId(reader.getValue());
				} else if (name.equals(ELEMENT_ROUTE_TABLE_ASSOCIATION_ID)) {
					vpnGateway.setRouteTableAssociationId(reader.getValue());
				} else if (name.equals(ELEMENT_CREATED_TIME)) {
					vpnGateway.setCreatedTime(DateUtils.toDate(reader.getValue()));
				}

				reader.moveUp();
			}

			vpnGateways.add(vpnGateway);
			reader.moveUp();
	}

		return vpnGateways;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
