/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model.transform;

import java.util.List;

import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.VpnGateway;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * DescribeVpnGatewaysResponseType変換クラス。<br />
 * このクラスはレスポンスXMLのDescribeVpnGatewaysResponse要素からDescribeVpnGatewaysResultクラスを生成します。
 */
public class DescribeVpnGatewaysResultConverter implements Converter {

	private static final String ELEMENT_REQUEST_ID = "requestId";
	private static final String ELEMENT_VPN_GATEWAY_SET = "vpnGatewaySet";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == DescribeVpnGatewaysResult.class;
	}

	/**
	 * {@literal
	 * DescribeVpnGatewaysResponseをDescribeVpnGatewaysResultクラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal DescribeVpnGatewaysResultオブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		DescribeVpnGatewaysResult describeVpnGatewaysResult = new DescribeVpnGatewaysResult();
		Converter vpnGatewaySetConverter = new VpnGatewaySetConverter();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();

			name = reader.getNodeName();
			if (name.equals(ELEMENT_REQUEST_ID)) {
				describeVpnGatewaysResult.setRequestId(reader.getValue());
			} else if (name.equals(ELEMENT_VPN_GATEWAY_SET)) {
				describeVpnGatewaysResult.setVpnGateways((List<VpnGateway>) vpnGatewaySetConverter.unmarshal(reader, context));
			}

			reader.moveUp();
		}

		return describeVpnGatewaysResult;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
