/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * VPNゲートウェイ情報クラス。<br />
 * このクラスはVPNゲートウェイ情報を格納します。
 *
 */
public class VpnGateway {

	/** VPNゲートウェイユニークID */
	private String vpnGatewayId;

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	/** VPNゲートウェイステータス */
	private String state;

	private String type;

	/** ゾーン名 */
	private String availabilityZone;

	private List<Attachment> attachments;

	/** リソースに設定されているタグ情報 */
	private List<Tag> tagSet;

	/** VPNゲートウェイのタイプ */
	private String niftyVpnGatewayType;

	/** 冗長化オプション */
	private Boolean niftyRedundancy;

	/** メモ */
	private String niftyVpnGatewayDescription;

	/** 利用料金タイプ */
	private String accountingType;

	/** 翌月の利用料金タイプ */
	private String nextMonthAccountingType;

	/** VPNゲートウェイのversion情報 */
	private VersionInformation versionInformation;

	/** ネットワークインターフェイス情報 */
	private List<NetworkInterfaceSet> networkInterfaces;

	/** バックアップ情報 */
	private BackupInformation backupInformation;

	/** ファイアウォールグループ名リスト */
	private List<String> groupIds;

	/** ルートテーブルID */
	private String routeTableId;

	/** ルートテーブル適用ID */
	private String routeTableAssociationId;

	/** 作成日時 */
	private Date createdTime;

	/**
	 * VPNゲートウェイユニークIDを取得します。
	 *
	 * @return VPNゲートウェイユニークID
	 */
	public String getVpnGatewayId() {
		return vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 */
	public void setVpnGatewayId(String vpnGatewayId) {
		this.vpnGatewayId = vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public VpnGateway withVpnGatewayId(String vpnGatewayId) {
		setVpnGatewayId(vpnGatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	public String getNiftyVpnGatewayName() {
		return niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
		this.niftyVpnGatewayName = niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public VpnGateway withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * VPNゲートウェイステータスを取得します。
	 *
	 * @return VPNゲートウェイステータス
	 */
	public String getState() {
		return state;
	}

	/**
	 * VPNゲートウェイステータスを設定します。
	 *
	 * @param state VPNゲートウェイステータス
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * VPNゲートウェイステータスを設定し、自オブジェクトを返します。
	 *
	 * @param state VPNゲートウェイステータス
	 * @return 自オブジェクト
	 */
	public VpnGateway withState(String state) {
		setState(state);
		return this;
	}

	/**
	 * typeを取得します。
	 *
	 * @return type
	 */
	public String getType() {
		return type;
	}

	/**
	 * typeを設定します。
	 *
	 * @param type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * typeを設定し、自オブジェクトを返します。
	 *
	 * @param type
	 * @return 自オブジェクト
	 */
	public VpnGateway withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * ゾーン名を取得します。
	 *
	 * @return ゾーン名
	 */
	public String getAvailabilityZone() {
		return availabilityZone;
	}

	/**
	 * ゾーン名を設定します。
	 *
	 * @param availabilityZone ゾーン名
	 */
	public void setAvailabilityZone(String availabilityZone) {
		this.availabilityZone = availabilityZone;
	}

	/**
	 * ゾーン名を設定し、自オブジェクトを返します。
	 *
	 * @param availabilityZone ゾーン名
	 * @return 自オブジェクト
	 */
	public VpnGateway withAvailabilityZone(String availabilityZone) {
		setAvailabilityZone(availabilityZone);
		return this;
	}

	/**
	 * attachmentsを取得します。
	 *
	 * @return attachments
	 */
	public List<Attachment> getAttachments() {
		return attachments;
	}

	/**
	 * attachmentsを設定します。
	 *
	 * @param attachments
	 */
	public void setAttachments(List<Attachment> attachments) {
		this.attachments = attachments;
	}

	/**
	 * attachmentsの配列を設定し、自オブジェクトを返します。
	 *
	 * @param attachments
	 * @return 自オブジェクト
	 */
	public VpnGateway withAttachments(Attachment ... attachments) {
		if (this.attachments == null) this.attachments = new ArrayList<Attachment>();
		for (Attachment attachment : attachments) {
			getAttachments().add(attachment);
		}
		return this;
	}

	/**
	 * attachmentsリストを設定し、自オブジェクトを返します。
	 *
	 * @param attachments
	 * @return 自オブジェクト
	 */
	public VpnGateway withAttachments(Collection<Attachment> attachments) {
		if (this.attachments == null) this.attachments = new ArrayList<Attachment>();
		if (attachments != null) {
			getAttachments().addAll(attachments);
		}
		return this;
	}

	/**
	 * リソースに設定されているタグ情報を取得します。
	 *
	 * @return リソースに設定されているタグ情報
	 */
	public List<Tag> getTagSet() {
		return tagSet;
	}

	/**
	 * リソースに設定されているタグ情報を設定します。
	 *
	 * @param tagSet リソースに設定されているタグ情報
	 */
	public void setTagSet(List<Tag> tagSet) {
		this.tagSet = tagSet;
	}

	/**
	 * リソースに設定されているタグ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報の配列
	 * @return 自オブジェクト
	 */
	public VpnGateway withTagSet(Tag ... tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		for (Tag tag : tagSet) {
			getTagSet().add(tag);
		}
		return this;
	}

	/**
	 * リソースに設定されているタグ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報リスト
	 * @return 自オブジェクト
	 */
	public VpnGateway withTagSet(Collection<Tag> tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		if (tagSet != null) {
			getTagSet().addAll(tagSet);
		}
		return this;
	}

	/**
	 * VPNゲートウェイのタイプを取得します。
	 *
	 * @return VPNゲートウェイのタイプ
	 */
	public String getNiftyVpnGatewayType() {
		return niftyVpnGatewayType;
	}

	/**
	 * VPNゲートウェイのタイプを設定します。
	 *
	 * @param niftyVpnGatewayType VPNゲートウェイのタイプ
	 */
	public void setNiftyVpnGatewayType(String niftyVpnGatewayType) {
		this.niftyVpnGatewayType = niftyVpnGatewayType;
	}

	/**
	 * VPNゲートウェイのタイプを設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayType VPNゲートウェイのタイプ
	 * @return 自オブジェクト
	 */
	public VpnGateway withNiftyVpnGatewayType(String niftyVpnGatewayType) {
		setNiftyVpnGatewayType(niftyVpnGatewayType);
		return this;
	}

	/**
	 * 冗長化オプションを取得します。
	 *
	 * @return 冗長化オプション
	 */
	public Boolean getNiftyRedundancy() {
		return niftyRedundancy;
	}

	/**
	 * 冗長化オプションを設定します。
	 *
	 * @param niftyRedundancy 冗長化オプション
	 */
	public void setNiftyRedundancy(Boolean niftyRedundancy) {
		this.niftyRedundancy = niftyRedundancy;
	}

	/**
	 * 冗長化オプションを設定し、自オブジェクトを返します。
	 *
	 * @param niftyRedundancy 冗長化オプション
	 * @return 自オブジェクト
	 */
	public VpnGateway withNiftyRedundancy(Boolean niftyRedundancy) {
		setNiftyRedundancy(niftyRedundancy);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	public String getNiftyVpnGatewayDescription() {
		return niftyVpnGatewayDescription;
	}

	/**
	 * メモを設定します。
	 *
	 * @param niftyVpnGatewayDescription メモ
	 */
	public void setNiftyVpnGatewayDescription(String niftyVpnGatewayDescription) {
		this.niftyVpnGatewayDescription = niftyVpnGatewayDescription;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayDescription メモ
	 * @return 自オブジェクト
	 */
	public VpnGateway withNiftyVpnGatewayDescription(String niftyVpnGatewayDescription) {
		setNiftyVpnGatewayDescription(niftyVpnGatewayDescription);
		return this;
	}

	/**
	 * 利用料金タイプを取得します。
	 *
	 * @return 利用料金タイプ
	 */
	public String getAccountingType() {
		return accountingType;
	}

	/**
	 * 利用料金タイプを設定します。
	 *
	 * @param accountingType 利用料金タイプ
	 */
	public void setAccountingType(String accountingType) {
		this.accountingType = accountingType;
	}

	/**
	 * 利用料金タイプを設定し、自オブジェクトを返します。
	 *
	 * @param accountingType 利用料金タイプ
	 * @return 自オブジェクト
	 */
	public VpnGateway withAccountingType(String accountingType) {
		setAccountingType(accountingType);
		return this;
	}

	/**
	 * 翌月の利用料金タイプを取得します。
	 *
	 * @return 翌月の利用料金タイプ
	 */
	public String getNextMonthAccountingType() {
		return nextMonthAccountingType;
	}

	/**
	 * 翌月の利用料金タイプを設定します。
	 *
	 * @param nextMonthAccountingType 翌月の利用料金タイプ
	 */
	public void setNextMonthAccountingType(String nextMonthAccountingType) {
		this.nextMonthAccountingType = nextMonthAccountingType;
	}

	/**
	 * 翌月の利用料金タイプを設定し、自オブジェクトを返します。
	 *
	 * @param nextMonthAccountingType 翌月の利用料金タイプ
	 * @return 自オブジェクト
	 */
	public VpnGateway withNextMonthAccountingType(String nextMonthAccountingType) {
		setNextMonthAccountingType(nextMonthAccountingType);
		return this;
	}

	/**
	 * VPNゲートウェイのversion情報を取得します。
	 *
	 * @return VPNゲートウェイのversion情報
	 */
	public VersionInformation getVersionInformation() {
		return versionInformation;
	}

	/**
	 * VPNゲートウェイのversion情報を設定します。
	 *
	 * @param versionInformation VPNゲートウェイのversion情報
	 */
	public void setVersionInformation(VersionInformation versionInformation) {
		this.versionInformation = versionInformation;
	}

	/**
	 * VPNゲートウェイのversion情報を設定し、自オブジェクトを返します。
	 *
	 * @param versionInformation VPNゲートウェイのversion情報
	 * @return 自オブジェクト
	 */
	public VpnGateway withVersionInformation(VersionInformation versionInformation) {
		setVersionInformation(versionInformation);
		return this;
	}

	/**
	 * ネットワークインターフェイス情報を取得します。
	 *
	 * @return ネットワークインターフェイス情報
	 */
	public List<NetworkInterfaceSet> getNetworkInterfaces() {
		return networkInterfaces;
	}

	/**
	 * ネットワークインターフェイス情報を設定します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報
	 */
	public void setNetworkInterfaces(List<NetworkInterfaceSet> networkInterfaces) {
		this.networkInterfaces = networkInterfaces;
	}

	/**
	 * ネットワークインターフェイス情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報の配列
	 * @return 自オブジェクト
	 */
	public VpnGateway withNetworkInterfaces(NetworkInterfaceSet ... networkInterfaces) {
		if (this.networkInterfaces == null) this.networkInterfaces = new ArrayList<NetworkInterfaceSet>();
		for (NetworkInterfaceSet networkInterface : networkInterfaces) {
			getNetworkInterfaces().add(networkInterface);
		}
		return this;
	}

	/**
	 * ネットワークインターフェイス情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param networkInterfaces ネットワークインターフェイス情報リスト
	 * @return 自オブジェクト
	 */
	public VpnGateway withNetworkInterfaces(Collection<NetworkInterfaceSet> networkInterfaces) {
		if (this.networkInterfaces == null) this.networkInterfaces = new ArrayList<NetworkInterfaceSet>();
		if (networkInterfaces != null) {
			getNetworkInterfaces().addAll(networkInterfaces);
		}
		return this;
	}

	/**
	 * バックアップ情報を取得します。
	 *
	 * @return バックアップ情報
	 */
	public BackupInformation getBackupInformation() {
		return backupInformation;
	}

	/**
	 * バックアップ情報を設定します。
	 *
	 * @param backupInformation バックアップ情報
	 */
	public void setBackupInformation(BackupInformation backupInformation) {
		this.backupInformation = backupInformation;
	}

	/**
	 * バックアップ情報を設定し、自オブジェクトを返します。
	 *
	 * @param backupInformation バックアップ情報
	 * @return 自オブジェクト
	 */
	public VpnGateway withBackupInformation(BackupInformation backupInformation) {
		setBackupInformation(backupInformation);
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを取得します。
	 *
	 * @return ファイアウォールグループ名リスト
	 */
	public List<String> getGroupIds() {
		return groupIds;
	}

	/**
	 * ファイアウォールグループ名リストを設定します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 */
	public void setGroupIds(List<String> groupIds) {
		this.groupIds = groupIds;
	}

	/**
	 * ファイアウォールグループ名の配列を設定し、自オブジェクトを返します。
	 *
	 * @param groupIds ファイアウォールグループ名の配列
	 * @return 自オブジェクト
	 */
	public VpnGateway withGroupIds(String ... groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		for (String groupId : groupIds) {
			getGroupIds().add(groupId);
		}
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを設定し、自オブジェクトを返します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 * @return 自オブジェクト
	 */
	public VpnGateway withGroupIds(Collection<String> groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		if (groupIds != null) {
			getGroupIds().addAll(groupIds);
		}
		return this;
	}

	/**
	 * ルートテーブルIDを取得します。
	 *
	 * @return ルートテーブルID
	 */
	public String getRouteTableId() {
		return routeTableId;
	}

	/**
	 * ルートテーブルIDを設定します。
	 *
	 * @param routeTableId ルートテーブルID
	 */
	public void setRouteTableId(String routeTableId) {
		this.routeTableId = routeTableId;
	}

	/**
	 * ルートテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableId ルートテーブルID
	 * @return 自オブジェクト
	 */
	public VpnGateway withRouteTableId(String routeTableId) {
		setRouteTableId(routeTableId);
		return this;
	}

	/**
	 * ルートテーブル適用IDを取得します。
	 *
	 * @return ルートテーブル適用ID
	 */
	public String getRouteTableAssociationId() {
		return routeTableAssociationId;
	}

	/**
	 * ルートテーブル適用IDを設定します。
	 *
	 * @param routeTableAssociationId ルートテーブル適用ID
	 */
	public void setRouteTableAssociationId(String routeTableAssociationId) {
		this.routeTableAssociationId = routeTableAssociationId;
	}

	/**
	 * ルートテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param routeTableAssociationId ルートテーブル適用ID
	 * @return 自オブジェクト
	 */
	public VpnGateway withRouteTableAssociationId(String routeTableAssociationId) {
		setRouteTableAssociationId(routeTableAssociationId);
		return this;
	}

	/**
	 * 作成日時を取得します。
	 *
	 * @return 作成日時
	 */
	public Date getCreatedTime() {
		return createdTime;
	}

	/**
	 * 作成日時を設定します。
	 *
	 * @param createdTime 作成日時
	 */
	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	/**
	 * 作成日時を設定し、自オブジェクトを返します。
	 *
	 * @param createdTime 作成日時
	 * @return 自オブジェクト
	 */
	public VpnGateway withCreatedTime(Date createdTime) {
		setCreatedTime(createdTime);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnGatewayId=");
		builder.append(vpnGatewayId);
		builder.append(", niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", state=");
		builder.append(state);
		builder.append(", type=");
		builder.append(type);
		builder.append(", availabilityZone=");
		builder.append(availabilityZone);
		builder.append(", attachments=");
		builder.append(attachments);
		builder.append(", tagSet=");
		builder.append(tagSet);
		builder.append(", niftyVpnGatewayType=");
		builder.append(niftyVpnGatewayType);
		builder.append(", niftyRedundancy=");
		builder.append(niftyRedundancy);
		builder.append(", niftyVpnGatewayDescription=");
		builder.append(niftyVpnGatewayDescription);
		builder.append(", accountingType=");
		builder.append(accountingType);
		builder.append(", nextMonthAccountingType=");
		builder.append(nextMonthAccountingType);
		builder.append(", versionInformation=");
		builder.append(versionInformation);
		builder.append(", networkInterfaces=");
		builder.append(networkInterfaces);
		builder.append(", backupInformation=");
		builder.append(backupInformation);
		builder.append(", groupIds=");
		builder.append(groupIds);
		builder.append(", routeTableId=");
		builder.append(routeTableId);
		builder.append(", routeTableAssociationId=");
		builder.append(routeTableAssociationId);
		builder.append(", createdTime=");
		builder.append(createdTime);
		builder.append("]");
		return builder.toString();
	}
}
