/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

/**
 * VPNゲートウェイのversion情報クラス。<br />
 * このクラスはVPNゲートウェイのversion情報を格納します。
 *
 */
public class VersionInformation {

	/** VPNゲートウェイのversion最新状態 */
	private Boolean isLatest;

	/** VPNゲートウェイのversion情報 */
	private String version;

	/**
	 * VPNゲートウェイのversion最新状態を取得します。
	 *
	 * @return VPNゲートウェイのversion最新状態
	 */
	public Boolean getIsLatest() {
		return isLatest;
	}

	/**
	 * VPNゲートウェイのversion最新状態を設定します。
	 *
	 * @param isLatest VPNゲートウェイのversion最新状態
	 */
	public void setIsLatest(Boolean isLatest) {
		this.isLatest = isLatest;
	}

	/**
	 * VPNゲートウェイのversion最新状態を設定し、自オブジェクトを返します。
	 *
	 * @param isLatest VPNゲートウェイのversion最新状態
	 * @return 自オブジェクト
	 */
	public VersionInformation withIsLatest(Boolean isLatest) {
		setIsLatest(isLatest);
		return this;
	}

	/**
	 * VPNゲートウェイのversion情報を取得します。
	 *
	 * @return VPNゲートウェイのversion情報
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * VPNゲートウェイのversion情報を設定します。
	 *
	 * @param version VPNゲートウェイのversion情報
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * VPNゲートウェイのversion情報を設定し、自オブジェクトを返します。
	 *
	 * @param version VPNゲートウェイのversion情報
	 * @return 自オブジェクト
	 */
	public VersionInformation withVersion(String version) {
		setVersion(version);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[isLatest=");
		builder.append(isLatest);
		builder.append(", version=");
		builder.append(version);
		builder.append("]");
		return builder.toString();
	}
}
