/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyUpdateVpnGatewayNetworkInterfacesリクエストクラス。<br />
 * このクラスはNiftyUpdateVpnGatewayNetworkInterfacesへのリクエストを構築します。
 *
 */
@Action("NiftyUpdateVpnGatewayNetworkInterfaces")
public class NiftyUpdateVpnGatewayNetworkInterfacesRequest implements Request {

	/** VPNゲートウェイユニークID */
	private String vpnGatewayId;

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	/** ネットワークインターフェイス情報 */
	private NetworkInterface networkInterface;

	/** 再起動オプション */
	private String niftyReboot;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * VPNゲートウェイユニークIDを取得します。
	 *
	 * @return VPNゲートウェイユニークID
	 */
	@Query(name="VpnGatewayId")
	public String getVpnGatewayId() {
		return vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 */
	public void setVpnGatewayId(String vpnGatewayId) {
		this.vpnGatewayId = vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public NiftyUpdateVpnGatewayNetworkInterfacesRequest withVpnGatewayId(String vpnGatewayId) {
		setVpnGatewayId(vpnGatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	@Query(name="NiftyVpnGatewayName")
	public String getNiftyVpnGatewayName() {
		return niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
		this.niftyVpnGatewayName = niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public NiftyUpdateVpnGatewayNetworkInterfacesRequest withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * ネットワークインターフェイス情報を取得します。
	 *
	 * @return ネットワークインターフェイス情報
	 */
	@Query(name="NetworkInterface")
	public NetworkInterface getNetworkInterface() {
		return networkInterface;
	}

	/**
	 * ネットワークインターフェイス情報を設定します。
	 *
	 * @param networkInterface ネットワークインターフェイス情報
	 */
	public void setNetworkInterface(NetworkInterface networkInterface) {
		this.networkInterface = networkInterface;
	}

	/**
	 * ネットワークインターフェイス情報を設定し、自オブジェクトを返します。
	 *
	 * @param networkInterface ネットワークインターフェイス情報
	 * @return 自オブジェクト
	 */
	public NiftyUpdateVpnGatewayNetworkInterfacesRequest withNetworkInterface(NetworkInterface networkInterface) {
		setNetworkInterface(networkInterface);
		return this;
	}

	/**
	 * 再起動オプションを取得します。
	 *
	 * @return 再起動オプション
	 */
	@Query(name="NiftyReboot")
	public String getNiftyReboot() {
		return niftyReboot;
	}

	/**
	 * 再起動オプションを設定します。
	 *
	 * @param niftyReboot 再起動オプション
	 */
	public void setNiftyReboot(String niftyReboot) {
		this.niftyReboot = niftyReboot;
	}

	/**
	 * 再起動オプションを設定し、自オブジェクトを返します。
	 *
	 * @param niftyReboot 再起動オプション
	 * @return 自オブジェクト
	 */
	public NiftyUpdateVpnGatewayNetworkInterfacesRequest withNiftyReboot(String niftyReboot) {
		setNiftyReboot(niftyReboot);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public NiftyUpdateVpnGatewayNetworkInterfacesRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnGatewayId=");
		builder.append(vpnGatewayId);
		builder.append(", niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", networkInterface=");
		builder.append(networkInterface);
		builder.append(", niftyReboot=");
		builder.append(niftyReboot);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
