/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import com.nifty.cloud.sdk.Result;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftyReplaceRouteTableAssociationWithVpnGateway処理結果クラス。<br />
 * このクラスはNiftyReplaceRouteTableAssociationWithVpnGatewayのレスポンスを格納します。
 */
@XStreamAlias("NiftyReplaceRouteTableAssociationWithVpnGatewayResponse")
public class NiftyReplaceRouteTableAssociationWithVpnGatewayResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** 新しいルートテーブル適用ID */
	private String newAssociationId;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyReplaceRouteTableAssociationWithVpnGatewayResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * 新しいルートテーブル適用IDを取得します。
	 *
	 * @return 新しいルートテーブル適用ID
	 */
	public String getNewAssociationId() {
		return newAssociationId;
	}

	/**
	 * 新しいルートテーブル適用IDを設定します。
	 *
	 * @param newAssociationId 新しいルートテーブル適用ID
	 */
	public void setNewAssociationId(String newAssociationId) {
		this.newAssociationId = newAssociationId;
	}

	/**
	 * 新しいルートテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param newAssociationId 新しいルートテーブル適用ID
	 * @return 自オブジェクト
	 */
	public NiftyReplaceRouteTableAssociationWithVpnGatewayResult withNewAssociationId(String newAssociationId) {
		setNewAssociationId(newAssociationId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", newAssociationId=");
		builder.append(newAssociationId);
		builder.append("]");
		return builder.toString();
	}
}
