/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyRebootVpnGatewaysリクエストクラス。<br />
 * このクラスはNiftyRebootVpnGatewaysへのリクエストを構築します。
 *
 */
@Action("NiftyRebootVpnGateways")
public class NiftyRebootVpnGatewaysRequest implements Request {

	/** VPNゲートウェイ情報リスト */
	private List<NiftyRebootVpnGateway> niftyRebootVpnGateways;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyRebootVpnGatewaysRequest() {
	}

	/**
	 * VPNゲートウェイ情報リストを指定し、NiftyRebootVpnGatewaysRequestを構築します。
	 *
	 * @param niftyRebootVpnGateways VPNゲートウェイ情報リスト
	 */
	public NiftyRebootVpnGatewaysRequest(List<NiftyRebootVpnGateway> niftyRebootVpnGateways) {
		this.niftyRebootVpnGateways = niftyRebootVpnGateways;
	}

	/**
	 * VPNゲートウェイ情報リストを取得します。
	 *
	 * @return VPNゲートウェイ情報リスト
	 */
	@Query(name="VpnGateway", require=true)
	public List<NiftyRebootVpnGateway> getNiftyRebootVpnGateways() {
		return niftyRebootVpnGateways;
	}

	/**
	 * VPNゲートウェイ情報リストを設定します。
	 *
	 * @param niftyRebootVpnGateways VPNゲートウェイ情報リスト
	 */
	public void setNiftyRebootVpnGateways(List<NiftyRebootVpnGateway> niftyRebootVpnGateways) {
		this.niftyRebootVpnGateways = niftyRebootVpnGateways;
	}

	/**
	 * VPNゲートウェイ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param niftyRebootVpnGateways VPNゲートウェイ情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyRebootVpnGatewaysRequest withNiftyRebootVpnGateways(NiftyRebootVpnGateway ... niftyRebootVpnGateways) {
		if (this.niftyRebootVpnGateways == null) this.niftyRebootVpnGateways = new ArrayList<NiftyRebootVpnGateway>();
		for (NiftyRebootVpnGateway niftyRebootVpnGateway : niftyRebootVpnGateways) {
			getNiftyRebootVpnGateways().add(niftyRebootVpnGateway);
		}
		return this;
	}

	/**
	 * VPNゲートウェイ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param niftyRebootVpnGateways VPNゲートウェイ情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyRebootVpnGatewaysRequest withNiftyRebootVpnGateways(Collection<NiftyRebootVpnGateway> niftyRebootVpnGateways) {
		if (this.niftyRebootVpnGateways == null) this.niftyRebootVpnGateways = new ArrayList<NiftyRebootVpnGateway>();
		if (niftyRebootVpnGateways != null) {
			getNiftyRebootVpnGateways().addAll(niftyRebootVpnGateways);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[niftyRebootVpnGateways=");
		builder.append(niftyRebootVpnGateways);
		builder.append("]");
		return builder.toString();
	}
}
