/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ネットワーク情報クラス。<br />
 * このクラスはネットワーク情報を格納します。
 *
 */
public class NiftyNetwork {

	/** プライベート側ネットワークID */
	private String networkId;

	/** プライベート側ネットワーク名 */
	private String networkName;

	/** プライベート側IPアドレス(IPv4) */
	private String ipAddress;

	/**
	 * プライベート側ネットワークIDを取得します。
	 *
	 * @return プライベート側ネットワークID
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * プライベート側ネットワークIDを設定します。
	 *
	 * @param networkId プライベート側ネットワークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * プライベート側ネットワークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId プライベート側ネットワークID
	 * @return 自オブジェクト
	 */
	public NiftyNetwork withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * プライベート側ネットワーク名を取得します。
	 *
	 * @return プライベート側ネットワーク名
	 */
	@Query(name="NetworkName")
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * プライベート側ネットワーク名を設定します。
	 *
	 * @param networkName プライベート側ネットワーク名
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * プライベート側ネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param networkName プライベート側ネットワーク名
	 * @return 自オブジェクト
	 */
	public NiftyNetwork withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/**
	 * プライベート側IPアドレス(IPv4)を取得します。
	 *
	 * @return プライベート側IPアドレス(IPv4)
	 */
	@Query(name="IpAddress")
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * プライベート側IPアドレス(IPv4)を設定します。
	 *
	 * @param ipAddress プライベート側IPアドレス(IPv4)
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * プライベート側IPアドレス(IPv4)を設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress プライベート側IPアドレス(IPv4)
	 * @return 自オブジェクト
	 */
	public NiftyNetwork withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append("]");
		return builder.toString();
	}
}
