/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyModifyVpnGatewayAttributeリクエストクラス。<br />
 * このクラスはNiftyModifyVpnGatewayAttributeへのリクエストを構築します。
 *
 */
@Action("NiftyModifyVpnGatewayAttribute")
public class NiftyModifyVpnGatewayAttributeRequest implements Request {

	/** VPNゲートウェイユニークID */
	private String vpnGatewayId;

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	/** 更新対象の項目名 */
	private String attribute;

	/** 更新値 */
	private String value;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * VPNゲートウェイユニークIDを取得します。
	 *
	 * @return VPNゲートウェイユニークID
	 */
	@Query(name="VpnGatewayId")
	public String getVpnGatewayId() {
		return vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 */
	public void setVpnGatewayId(String vpnGatewayId) {
		this.vpnGatewayId = vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public NiftyModifyVpnGatewayAttributeRequest withVpnGatewayId(String vpnGatewayId) {
		setVpnGatewayId(vpnGatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	@Query(name="NiftyVpnGatewayName")
	public String getNiftyVpnGatewayName() {
		return niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
		this.niftyVpnGatewayName = niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public NiftyModifyVpnGatewayAttributeRequest withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * 更新対象の項目名を取得します。
	 *
	 * @return 更新対象の項目名
	 */
	@Query(name="Attribute")
	public String getAttribute() {
		return attribute;
	}

	/**
	 * 更新対象の項目名を設定します。
	 *
	 * @param attribute 更新対象の項目名
	 */
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}

	/**
	 * 更新対象の項目名を設定し、自オブジェクトを返します。
	 *
	 * @param attribute 更新対象の項目名
	 * @return 自オブジェクト
	 */
	public NiftyModifyVpnGatewayAttributeRequest withAttribute(String attribute) {
		setAttribute(attribute);
		return this;
	}

	/**
	 * 更新値を取得します。
	 *
	 * @return 更新値
	 */
	@Query(name="Value")
	public String getValue() {
		return value;
	}

	/**
	 * 更新値を設定します。
	 *
	 * @param value 更新値
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * 更新値を設定し、自オブジェクトを返します。
	 *
	 * @param value 更新値
	 * @return 自オブジェクト
	 */
	public NiftyModifyVpnGatewayAttributeRequest withValue(String value) {
		setValue(value);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public NiftyModifyVpnGatewayAttributeRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnGatewayId=");
		builder.append(vpnGatewayId);
		builder.append(", niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", attribute=");
		builder.append(attribute);
		builder.append(", value=");
		builder.append(value);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
