/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.vpngateway.model.transform.NiftyDescribeVpnGatewayActivitiesResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeVpnGatewayActivities処理結果クラス。<br />
 * このクラスはNiftyDescribeVpnGatewayActivitiesのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeVpnGatewayActivitiesResponse")
@XStreamConverter(NiftyDescribeVpnGatewayActivitiesResultConverter.class)
public class NiftyDescribeVpnGatewayActivitiesResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** VPNゲートウェイユニークID */
	private String vpnGatewayId;

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	/** VPNゲートウェイ接続ログ(CDATA付) */
	private String log;

	/** VPN接続情報 */
	private List<AnalyzeResult> analyzeResults;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyDescribeVpnGatewayActivitiesResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * VPNゲートウェイユニークIDを取得します。
	 *
	 * @return VPNゲートウェイユニークID
	 */
	public String getVpnGatewayId() {
		return vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 */
	public void setVpnGatewayId(String vpnGatewayId) {
		this.vpnGatewayId = vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public NiftyDescribeVpnGatewayActivitiesResult withVpnGatewayId(String vpnGatewayId) {
		setVpnGatewayId(vpnGatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	public String getNiftyVpnGatewayName() {
		return niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
		this.niftyVpnGatewayName = niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public NiftyDescribeVpnGatewayActivitiesResult withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * VPNゲートウェイ接続ログ(CDATA付)を取得します。
	 *
	 * @return VPNゲートウェイ接続ログ(CDATA付)
	 */
	public String getLog() {
		return log;
	}

	/**
	 * VPNゲートウェイ接続ログ(CDATA付)を設定します。
	 *
	 * @param log VPNゲートウェイ接続ログ(CDATA付)
	 */
	public void setLog(String log) {
		this.log = log;
	}

	/**
	 * VPNゲートウェイ接続ログ(CDATA付)を設定し、自オブジェクトを返します。
	 *
	 * @param log VPNゲートウェイ接続ログ(CDATA付)
	 * @return 自オブジェクト
	 */
	public NiftyDescribeVpnGatewayActivitiesResult withLog(String log) {
		setLog(log);
		return this;
	}

	/**
	 * VPN接続情報を取得します。
	 *
	 * @return VPN接続情報
	 */
	public List<AnalyzeResult> getAnalyzeResults() {
		return analyzeResults;
	}

	/**
	 * VPN接続情報を設定します。
	 *
	 * @param analyzeResults VPN接続情報
	 */
	public void setAnalyzeResults(List<AnalyzeResult> analyzeResults) {
		this.analyzeResults = analyzeResults;
	}

	/**
	 * VPN接続情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param analyzeResults VPN接続情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribeVpnGatewayActivitiesResult withAnalyzeResults(AnalyzeResult ... analyzeResults) {
		if (this.analyzeResults == null) this.analyzeResults = new ArrayList<AnalyzeResult>();
		for (AnalyzeResult analyzeResult : analyzeResults) {
			getAnalyzeResults().add(analyzeResult);
		}
		return this;
	}

	/**
	 * VPN接続情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param analyzeResults VPN接続情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribeVpnGatewayActivitiesResult withAnalyzeResults(Collection<AnalyzeResult> analyzeResults) {
		if (this.analyzeResults == null) this.analyzeResults = new ArrayList<AnalyzeResult>();
		if (analyzeResults != null) {
			getAnalyzeResults().addAll(analyzeResults);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", vpnGatewayId=");
		builder.append(vpnGatewayId);
		builder.append(", niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", log=");
		builder.append(log);
		builder.append(", analyzeResults=");
		builder.append(analyzeResults);
		builder.append("]");
		return builder.toString();
	}
}
