/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import com.nifty.cloud.sdk.Result;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftyAssociateRouteTableWithVpnGateway処理結果クラス。<br />
 * このクラスはNiftyAssociateRouteTableWithVpnGatewayのレスポンスを格納します。
 */
@XStreamAlias("NiftyAssociateRouteTableWithVpnGatewayResponse")
public class NiftyAssociateRouteTableWithVpnGatewayResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** ルートテーブル適用ID */
	private String associationId;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyAssociateRouteTableWithVpnGatewayResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * ルートテーブル適用IDを取得します。
	 *
	 * @return ルートテーブル適用ID
	 */
	public String getAssociationId() {
		return associationId;
	}

	/**
	 * ルートテーブル適用IDを設定します。
	 *
	 * @param associationId ルートテーブル適用ID
	 */
	public void setAssociationId(String associationId) {
		this.associationId = associationId;
	}

	/**
	 * ルートテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param associationId ルートテーブル適用ID
	 * @return 自オブジェクト
	 */
	public NiftyAssociateRouteTableWithVpnGatewayResult withAssociationId(String associationId) {
		setAssociationId(associationId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", associationId=");
		builder.append(associationId);
		builder.append("]");
		return builder.toString();
	}
}
