/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ネットワークインターフェイス情報クラス。<br />
 * このクラスはネットワークインターフェイス情報を格納します。
 *
 */
public class NetworkInterface {

	private Integer deviceIndex;

	private List<String> groupIds;

	private String networkId;

	private String networkName;

	/** IPアドレス */
	private String ipAddress;

	/**
	 * deviceIndexを取得します。
	 *
	 * @return deviceIndex
	 */
	@Query(name="DeviceIndex")
	public Integer getDeviceIndex() {
		return deviceIndex;
	}

	/**
	 * deviceIndexを設定します。
	 *
	 * @param deviceIndex
	 */
	public void setDeviceIndex(Integer deviceIndex) {
		this.deviceIndex = deviceIndex;
	}

	/**
	 * deviceIndexを設定し、自オブジェクトを返します。
	 *
	 * @param deviceIndex
	 * @return 自オブジェクト
	 */
	public NetworkInterface withDeviceIndex(Integer deviceIndex) {
		setDeviceIndex(deviceIndex);
		return this;
	}

	/**
	 * groupIdsを取得します。
	 *
	 * @return groupIds
	 */
	@Query(name="SecurityGroupId")
	public List<String> getGroupIds() {
		return groupIds;
	}

	/**
	 * groupIdsを設定します。
	 *
	 * @param groupIds
	 */
	public void setGroupIds(List<String> groupIds) {
		this.groupIds = groupIds;
	}

	/**
	 * groupIdsの配列を設定し、自オブジェクトを返します。
	 *
	 * @param groupIds
	 * @return 自オブジェクト
	 */
	public NetworkInterface withGroupIds(String ... groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		for (String groupId : groupIds) {
			getGroupIds().add(groupId);
		}
		return this;
	}

	/**
	 * groupIdsリストを設定し、自オブジェクトを返します。
	 *
	 * @param groupIds
	 * @return 自オブジェクト
	 */
	public NetworkInterface withGroupIds(Collection<String> groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		if (groupIds != null) {
			getGroupIds().addAll(groupIds);
		}
		return this;
	}

	/**
	 * networkIdを取得します。
	 *
	 * @return networkId
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * networkIdを設定します。
	 *
	 * @param networkId
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * networkIdを設定し、自オブジェクトを返します。
	 *
	 * @param networkId
	 * @return 自オブジェクト
	 */
	public NetworkInterface withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * networkNameを取得します。
	 *
	 * @return networkName
	 */
	@Query(name="NetworkName")
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * networkNameを設定します。
	 *
	 * @param networkName
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * networkNameを設定し、自オブジェクトを返します。
	 *
	 * @param networkName
	 * @return 自オブジェクト
	 */
	public NetworkInterface withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/**
	 * IPアドレスを取得します。
	 *
	 * @return IPアドレス
	 */
	@Query(name="IpAddress")
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * IPアドレスを設定します。
	 *
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress IPアドレス
	 * @return 自オブジェクト
	 */
	public NetworkInterface withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[deviceIndex=");
		builder.append(deviceIndex);
		builder.append(", groupIds=");
		builder.append(groupIds);
		builder.append(", networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append("]");
		return builder.toString();
	}
}
