/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.vpngateway.model.transform.DescribeVpnGatewaysResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * DescribeVpnGateways処理結果クラス。<br />
 * このクラスはDescribeVpnGatewaysのレスポンスを格納します。
 */
@XStreamAlias("DescribeVpnGatewaysResponse")
@XStreamConverter(DescribeVpnGatewaysResultConverter.class)
public class DescribeVpnGatewaysResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** VPNゲートウェイ情報リスト */
	private List<VpnGateway> vpnGateways;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public DescribeVpnGatewaysResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * VPNゲートウェイ情報リストを取得します。
	 *
	 * @return VPNゲートウェイ情報リスト
	 */
	public List<VpnGateway> getVpnGateways() {
		return vpnGateways;
	}

	/**
	 * VPNゲートウェイ情報リストを設定します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報リスト
	 */
	public void setVpnGateways(List<VpnGateway> vpnGateways) {
		this.vpnGateways = vpnGateways;
	}

	/**
	 * VPNゲートウェイ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeVpnGatewaysResult withVpnGateways(VpnGateway ... vpnGateways) {
		if (this.vpnGateways == null) this.vpnGateways = new ArrayList<VpnGateway>();
		for (VpnGateway vpnGateway : vpnGateways) {
			getVpnGateways().add(vpnGateway);
		}
		return this;
	}

	/**
	 * VPNゲートウェイ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeVpnGatewaysResult withVpnGateways(Collection<VpnGateway> vpnGateways) {
		if (this.vpnGateways == null) this.vpnGateways = new ArrayList<VpnGateway>();
		if (vpnGateways != null) {
			getVpnGateways().addAll(vpnGateways);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", vpnGateways=");
		builder.append(vpnGateways);
		builder.append("]");
		return builder.toString();
	}
}
