/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DescribeVpnGatewaysリクエストクラス。<br />
 * このクラスはDescribeVpnGatewaysへのリクエストを構築します。
 *
 */
@Action("DescribeVpnGateways")
public class DescribeVpnGatewaysRequest implements Request {

	/** VPNゲートウェイ情報リスト */
	private List<VpnGatewayIdSet> vpnGateways;

	/** 絞り込み情報リスト */
	private List<Filter> filters;

	/**
	 * VPNゲートウェイ情報リストを取得します。
	 *
	 * @return VPNゲートウェイ情報リスト
	 */
	@Query(name="")
	public List<VpnGatewayIdSet> getVpnGateways() {
		return vpnGateways;
	}

	/**
	 * VPNゲートウェイ情報リストを設定します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報リスト
	 */
	public void setVpnGateways(List<VpnGatewayIdSet> vpnGateways) {
		this.vpnGateways = vpnGateways;
	}

	/**
	 * VPNゲートウェイ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeVpnGatewaysRequest withVpnGateways(VpnGatewayIdSet ... vpnGateways) {
		if (this.vpnGateways == null) this.vpnGateways = new ArrayList<VpnGatewayIdSet>();
		for (VpnGatewayIdSet vpnGateway : vpnGateways) {
			getVpnGateways().add(vpnGateway);
		}
		return this;
	}

	/**
	 * VPNゲートウェイ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeVpnGatewaysRequest withVpnGateways(Collection<VpnGatewayIdSet> vpnGateways) {
		if (this.vpnGateways == null) this.vpnGateways = new ArrayList<VpnGatewayIdSet>();
		if (vpnGateways != null) {
			getVpnGateways().addAll(vpnGateways);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを取得します。
	 *
	 * @return 絞り込み情報リスト
	 */
	@Query(name="Filter")
	public List<Filter> getFilters() {
		return filters;
	}

	/**
	 * 絞り込み情報リストを設定します。
	 *
	 * @param filters 絞り込み情報リスト
	 */
	public void setFilters(List<Filter> filters) {
		this.filters = filters;
	}

	/**
	 * 絞り込み情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeVpnGatewaysRequest withFilters(Filter ... filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		for (Filter filter : filters) {
			getFilters().add(filter);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeVpnGatewaysRequest withFilters(Collection<Filter> filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		if (filters != null) {
			getFilters().addAll(filters);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnGateways=");
		builder.append(vpnGateways);
		builder.append(", filters=");
		builder.append(filters);
		builder.append("]");
		return builder.toString();
	}
}
