/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * CreateVpnGatewayリクエストクラス。<br />
 * このクラスはCreateVpnGatewayへのリクエストを構築します。
 *
 */
@Action("CreateVpnGateway")
public class CreateVpnGatewayRequest implements Request {

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	private String type;

	/** VPNゲートウェイのタイプ */
	private String niftyVpnGatewayType;

	/** 冗長化オプション */
	private Boolean niftyRedundancy;

	/** ゾーン情報 */
	private VpnGatewayPlacement placement;

	/** 利用料金タイプ */
	private String accountingType;

	/** メモ */
	private String niftyVpnGatewayDescription;

	/** プライベート側ネットワーク情報 */
	private NiftyNetwork niftyNetwork;

	/** ファイアウォールグループ名リスト */
	private List<String> groupIds;

	/**
	 * デフォルトコンストラクタ。
	 */
	public CreateVpnGatewayRequest() {
	}

	/**
	 * プライベート側ネットワーク情報を指定し、CreateVpnGatewayRequestを構築します。
	 *
	 * @param niftyNetwork プライベート側ネットワーク情報
	 */
	public CreateVpnGatewayRequest(NiftyNetwork niftyNetwork) {
		this.niftyNetwork = niftyNetwork;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	@Query(name="NiftyVpnGatewayName")
	public String getNiftyVpnGatewayName() {
		return niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
		this.niftyVpnGatewayName = niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * typeを取得します。
	 *
	 * @return type
	 */
	@Query(name="Type")
	public String getType() {
		return type;
	}

	/**
	 * typeを設定します。
	 *
	 * @param type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * typeを設定し、自オブジェクトを返します。
	 *
	 * @param type
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * VPNゲートウェイのタイプを取得します。
	 *
	 * @return VPNゲートウェイのタイプ
	 */
	@Query(name="NiftyVpnGatewayType")
	public String getNiftyVpnGatewayType() {
		return niftyVpnGatewayType;
	}

	/**
	 * VPNゲートウェイのタイプを設定します。
	 *
	 * @param niftyVpnGatewayType VPNゲートウェイのタイプ
	 */
	public void setNiftyVpnGatewayType(String niftyVpnGatewayType) {
		this.niftyVpnGatewayType = niftyVpnGatewayType;
	}

	/**
	 * VPNゲートウェイのタイプを設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayType VPNゲートウェイのタイプ
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withNiftyVpnGatewayType(String niftyVpnGatewayType) {
		setNiftyVpnGatewayType(niftyVpnGatewayType);
		return this;
	}

	/**
	 * 冗長化オプションを取得します。
	 *
	 * @return 冗長化オプション
	 */
	@Query(name="NiftyRedundancy")
	public Boolean getNiftyRedundancy() {
		return niftyRedundancy;
	}

	/**
	 * 冗長化オプションを設定します。
	 *
	 * @param niftyRedundancy 冗長化オプション
	 */
	public void setNiftyRedundancy(Boolean niftyRedundancy) {
		this.niftyRedundancy = niftyRedundancy;
	}

	/**
	 * 冗長化オプションを設定し、自オブジェクトを返します。
	 *
	 * @param niftyRedundancy 冗長化オプション
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withNiftyRedundancy(Boolean niftyRedundancy) {
		setNiftyRedundancy(niftyRedundancy);
		return this;
	}

	/**
	 * ゾーン情報を取得します。
	 *
	 * @return ゾーン情報
	 */
	@Query(name="Placement")
	public VpnGatewayPlacement getPlacement() {
		return placement;
	}

	/**
	 * ゾーン情報を設定します。
	 *
	 * @param placement ゾーン情報
	 */
	public void setPlacement(VpnGatewayPlacement placement) {
		this.placement = placement;
	}

	/**
	 * ゾーン情報を設定し、自オブジェクトを返します。
	 *
	 * @param placement ゾーン情報
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withPlacement(VpnGatewayPlacement placement) {
		setPlacement(placement);
		return this;
	}

	/**
	 * 利用料金タイプを取得します。
	 *
	 * @return 利用料金タイプ
	 */
	@Query(name="AccountingType")
	public String getAccountingType() {
		return accountingType;
	}

	/**
	 * 利用料金タイプを設定します。
	 *
	 * @param accountingType 利用料金タイプ
	 */
	public void setAccountingType(String accountingType) {
		this.accountingType = accountingType;
	}

	/**
	 * 利用料金タイプを設定し、自オブジェクトを返します。
	 *
	 * @param accountingType 利用料金タイプ
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withAccountingType(String accountingType) {
		setAccountingType(accountingType);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	@Query(name="NiftyVpnGatewayDescription")
	public String getNiftyVpnGatewayDescription() {
		return niftyVpnGatewayDescription;
	}

	/**
	 * メモを設定します。
	 *
	 * @param niftyVpnGatewayDescription メモ
	 */
	public void setNiftyVpnGatewayDescription(String niftyVpnGatewayDescription) {
		this.niftyVpnGatewayDescription = niftyVpnGatewayDescription;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayDescription メモ
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withNiftyVpnGatewayDescription(String niftyVpnGatewayDescription) {
		setNiftyVpnGatewayDescription(niftyVpnGatewayDescription);
		return this;
	}

	/**
	 * プライベート側ネットワーク情報を取得します。
	 *
	 * @return プライベート側ネットワーク情報
	 */
	@Query(name="NiftyNetwork", require=true)
	public NiftyNetwork getNiftyNetwork() {
		return niftyNetwork;
	}

	/**
	 * プライベート側ネットワーク情報を設定します。
	 *
	 * @param niftyNetwork プライベート側ネットワーク情報
	 */
	public void setNiftyNetwork(NiftyNetwork niftyNetwork) {
		this.niftyNetwork = niftyNetwork;
	}

	/**
	 * プライベート側ネットワーク情報を設定し、自オブジェクトを返します。
	 *
	 * @param niftyNetwork プライベート側ネットワーク情報
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withNiftyNetwork(NiftyNetwork niftyNetwork) {
		setNiftyNetwork(niftyNetwork);
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを取得します。
	 *
	 * @return ファイアウォールグループ名リスト
	 */
	@Query(name="SecurityGroup")
	public List<String> getGroupIds() {
		return groupIds;
	}

	/**
	 * ファイアウォールグループ名リストを設定します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 */
	public void setGroupIds(List<String> groupIds) {
		this.groupIds = groupIds;
	}

	/**
	 * ファイアウォールグループ名の配列を設定し、自オブジェクトを返します。
	 *
	 * @param groupIds ファイアウォールグループ名の配列
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withGroupIds(String ... groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		for (String groupId : groupIds) {
			getGroupIds().add(groupId);
		}
		return this;
	}

	/**
	 * ファイアウォールグループ名リストを設定し、自オブジェクトを返します。
	 *
	 * @param groupIds ファイアウォールグループ名リスト
	 * @return 自オブジェクト
	 */
	public CreateVpnGatewayRequest withGroupIds(Collection<String> groupIds) {
		if (this.groupIds == null) this.groupIds = new ArrayList<String>();
		if (groupIds != null) {
			getGroupIds().addAll(groupIds);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", type=");
		builder.append(type);
		builder.append(", niftyVpnGatewayType=");
		builder.append(niftyVpnGatewayType);
		builder.append(", niftyRedundancy=");
		builder.append(niftyRedundancy);
		builder.append(", placement=");
		builder.append(placement);
		builder.append(", accountingType=");
		builder.append(accountingType);
		builder.append(", niftyVpnGatewayDescription=");
		builder.append(niftyVpnGatewayDescription);
		builder.append(", niftyNetwork=");
		builder.append(niftyNetwork);
		builder.append(", groupIds=");
		builder.append(groupIds);
		builder.append("]");
		return builder.toString();
	}
}
