/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

/**
 * Attachmentクラス。<br />
 * このクラスはAttachmentを格納します。
 *
 */
public class Attachment {

	private String vpcId;

	private String state;

	/**
	 * vpcIdを取得します。
	 *
	 * @return vpcId
	 */
	public String getVpcId() {
		return vpcId;
	}

	/**
	 * vpcIdを設定します。
	 *
	 * @param vpcId
	 */
	public void setVpcId(String vpcId) {
		this.vpcId = vpcId;
	}

	/**
	 * vpcIdを設定し、自オブジェクトを返します。
	 *
	 * @param vpcId
	 * @return 自オブジェクト
	 */
	public Attachment withVpcId(String vpcId) {
		setVpcId(vpcId);
		return this;
	}

	/**
	 * stateを取得します。
	 *
	 * @return state
	 */
	public String getState() {
		return state;
	}

	/**
	 * stateを設定します。
	 *
	 * @param state
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * stateを設定し、自オブジェクトを返します。
	 *
	 * @param state
	 * @return 自オブジェクト
	 */
	public Attachment withState(String state) {
		setState(state);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpcId=");
		builder.append(vpcId);
		builder.append(", state=");
		builder.append(state);
		builder.append("]");
		return builder.toString();
	}
}
