/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway.model;

/**
 * VPN接続情報クラス。<br />
 * このクラスはVPN接続情報を格納します。
 *
 */
public class AnalyzeResult {

	/** 行数 */
	private String line;

	/** 解析結果コード */
	private String analyzeCode;

	/**
	 * 行数を取得します。
	 *
	 * @return 行数
	 */
	public String getLine() {
		return line;
	}

	/**
	 * 行数を設定します。
	 *
	 * @param line 行数
	 */
	public void setLine(String line) {
		this.line = line;
	}

	/**
	 * 行数を設定し、自オブジェクトを返します。
	 *
	 * @param line 行数
	 * @return 自オブジェクト
	 */
	public AnalyzeResult withLine(String line) {
		setLine(line);
		return this;
	}

	/**
	 * 解析結果コードを取得します。
	 *
	 * @return 解析結果コード
	 */
	public String getAnalyzeCode() {
		return analyzeCode;
	}

	/**
	 * 解析結果コードを設定します。
	 *
	 * @param analyzeCode 解析結果コード
	 */
	public void setAnalyzeCode(String analyzeCode) {
		this.analyzeCode = analyzeCode;
	}

	/**
	 * 解析結果コードを設定し、自オブジェクトを返します。
	 *
	 * @param analyzeCode 解析結果コード
	 * @return 自オブジェクト
	 */
	public AnalyzeResult withAnalyzeCode(String analyzeCode) {
		setAnalyzeCode(analyzeCode);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[line=");
		builder.append(line);
		builder.append(", analyzeCode=");
		builder.append(analyzeCode);
		builder.append("]");
		return builder.toString();
	}
}
