/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * VPNゲートウェイカテゴリ クライアント。<br />
 * VPNゲートウェイ カテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public class NiftyVpnGatewayClient extends BaseClient implements NiftyVpnGateway {

	/**
	 * 認証情報を指定し、VPNゲートウェイカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyVpnGatewayClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、VPNゲートウェイカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyVpnGatewayClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#createVpnGateway(com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayRequest)
	 */
	@Override
	public CreateVpnGatewayResult createVpnGateway(CreateVpnGatewayRequest request) {
		return (CreateVpnGatewayResult) client.execute(request, CreateVpnGatewayResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#deleteVpnGateway(com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayRequest)
	 */
	@Override
	public DeleteVpnGatewayResult deleteVpnGateway(DeleteVpnGatewayRequest request) {
		return (DeleteVpnGatewayResult) client.execute(request, DeleteVpnGatewayResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#describeVpnGateways(com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysRequest)
	 */
	@Override
	public DescribeVpnGatewaysResult describeVpnGateways(DescribeVpnGatewaysRequest request) {
		return (DescribeVpnGatewaysResult) client.execute(request, DescribeVpnGatewaysResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyDescribeVpnGatewayActivities(com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesRequest)
	 */
	@Override
	public NiftyDescribeVpnGatewayActivitiesResult niftyDescribeVpnGatewayActivities(NiftyDescribeVpnGatewayActivitiesRequest request) {
		return (NiftyDescribeVpnGatewayActivitiesResult) client.execute(request, NiftyDescribeVpnGatewayActivitiesResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyModifyVpnGatewayAttribute(com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeRequest)
	 */
	@Override
	public NiftyModifyVpnGatewayAttributeResult niftyModifyVpnGatewayAttribute(NiftyModifyVpnGatewayAttributeRequest request) {
		return (NiftyModifyVpnGatewayAttributeResult) client.execute(request, NiftyModifyVpnGatewayAttributeResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyRebootVpnGateways(com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysRequest)
	 */
	@Override
	public NiftyRebootVpnGatewaysResult niftyRebootVpnGateways(NiftyRebootVpnGatewaysRequest request) {
		return (NiftyRebootVpnGatewaysResult) client.execute(request, NiftyRebootVpnGatewaysResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyAssociateRouteTableWithVpnGateway(com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayRequest)
	 */
	@Override
	public NiftyAssociateRouteTableWithVpnGatewayResult niftyAssociateRouteTableWithVpnGateway(NiftyAssociateRouteTableWithVpnGatewayRequest request) {
		return (NiftyAssociateRouteTableWithVpnGatewayResult) client.execute(request, NiftyAssociateRouteTableWithVpnGatewayResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyDisassociateRouteTableFromVpnGateway(com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayRequest)
	 */
	@Override
	public NiftyDisassociateRouteTableFromVpnGatewayResult niftyDisassociateRouteTableFromVpnGateway(NiftyDisassociateRouteTableFromVpnGatewayRequest request) {
		return (NiftyDisassociateRouteTableFromVpnGatewayResult) client.execute(request, NiftyDisassociateRouteTableFromVpnGatewayResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyReplaceRouteTableAssociationWithVpnGateway(com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayRequest)
	 */
	@Override
	public NiftyReplaceRouteTableAssociationWithVpnGatewayResult niftyReplaceRouteTableAssociationWithVpnGateway(NiftyReplaceRouteTableAssociationWithVpnGatewayRequest request) {
		return (NiftyReplaceRouteTableAssociationWithVpnGatewayResult) client.execute(request, NiftyReplaceRouteTableAssociationWithVpnGatewayResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyReplaceVpnGatewayLatestVersion(com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionRequest)
	 */
	@Override
	public NiftyReplaceVpnGatewayLatestVersionResult niftyReplaceVpnGatewayLatestVersion(NiftyReplaceVpnGatewayLatestVersionRequest request) {
		return (NiftyReplaceVpnGatewayLatestVersionResult) client.execute(request, NiftyReplaceVpnGatewayLatestVersionResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyRestoreVpnGatewayPreviousVersion(com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionRequest)
	 */
	@Override
	public NiftyRestoreVpnGatewayPreviousVersionResult niftyRestoreVpnGatewayPreviousVersion(NiftyRestoreVpnGatewayPreviousVersionRequest request) {
		return (NiftyRestoreVpnGatewayPreviousVersionResult) client.execute(request, NiftyRestoreVpnGatewayPreviousVersionResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyReleaseVpnGatewayBackupState(com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateRequest)
	 */
	@Override
	public NiftyReleaseVpnGatewayBackupStateResult niftyReleaseVpnGatewayBackupState(NiftyReleaseVpnGatewayBackupStateRequest request) {
		return (NiftyReleaseVpnGatewayBackupStateResult) client.execute(request, NiftyReleaseVpnGatewayBackupStateResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGateway#niftyUpdateVpnGatewayNetworkInterfaces(com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesRequest)
	 */
	@Override
	public NiftyUpdateVpnGatewayNetworkInterfacesResult niftyUpdateVpnGatewayNetworkInterfaces(NiftyUpdateVpnGatewayNetworkInterfacesRequest request) {
		return (NiftyUpdateVpnGatewayNetworkInterfacesResult) client.execute(request, NiftyUpdateVpnGatewayNetworkInterfacesResult.class);
	}
}