/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesResult;

/**
 * NIFCLOUD API 非同期クライアント 具象クラス。
 * VPNゲートウェイカテゴリクライアント。<br />
 * VPNゲートウェイ カテゴリの非同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public class NiftyVpnGatewayAsyncClient extends NiftyVpnGatewayClient implements NiftyVpnGatewayAsync {


	/** 非同期タスク実行クラス. */
	protected ExecutorService executorService = null;

	/**
	 * 認証情報を指定し、VPNゲートウェイカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyVpnGatewayAsyncClient(Credentials credential) {
		this(credential, Executors.newCachedThreadPool());
	}

	/**
	 * 認証情報、クライアント設定を指定し、VPNゲートウェイカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyVpnGatewayAsyncClient(Credentials credential, ClientConfiguration configuration) {
		this(credential, configuration, Executors.newCachedThreadPool());
	}

	/**
	 * 認証情報,非同期タスク実行クラスを指定し、VPNゲートウェイカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param executorService 非同期タスク実行クラス
	 */
	public NiftyVpnGatewayAsyncClient(Credentials credential, ExecutorService executorService) {
		super(credential);
		this.executorService = executorService;

	}

	/**
	 * 認証情報、クライアント設定,非同期タスク実行クラスを指定し、VPNゲートウェイカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 * @param executorService 非同期タスク実行クラス
	 */
	public NiftyVpnGatewayAsyncClient(Credentials credential, ClientConfiguration configuration, ExecutorService executorService) {
		super(credential, configuration);
		this.executorService = executorService;
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#createVpnGatewayAsync(com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayRequest)
	 */
	@Override
	public Future<CreateVpnGatewayResult> createVpnGatewayAsync(final CreateVpnGatewayRequest request) {
		return executorService.submit(
				new Callable<CreateVpnGatewayResult>() {
					@Override
					public CreateVpnGatewayResult call() {
						return createVpnGateway(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#deleteVpnGatewayAsync(com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayRequest)
	 */
	@Override
	public Future<DeleteVpnGatewayResult> deleteVpnGatewayAsync(final DeleteVpnGatewayRequest request) {
		return executorService.submit(
				new Callable<DeleteVpnGatewayResult>() {
					@Override
					public DeleteVpnGatewayResult call() {
						return deleteVpnGateway(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#describeVpnGatewaysAsync(com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysRequest)
	 */
	@Override
	public Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync(final DescribeVpnGatewaysRequest request) {
		return executorService.submit(
				new Callable<DescribeVpnGatewaysResult>() {
					@Override
					public DescribeVpnGatewaysResult call() {
						return describeVpnGateways(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyDescribeVpnGatewayActivitiesAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesRequest)
	 */
	@Override
	public Future<NiftyDescribeVpnGatewayActivitiesResult> niftyDescribeVpnGatewayActivitiesAsync(final NiftyDescribeVpnGatewayActivitiesRequest request) {
		return executorService.submit(
				new Callable<NiftyDescribeVpnGatewayActivitiesResult>() {
					@Override
					public NiftyDescribeVpnGatewayActivitiesResult call() {
						return niftyDescribeVpnGatewayActivities(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyModifyVpnGatewayAttributeAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeRequest)
	 */
	@Override
	public Future<NiftyModifyVpnGatewayAttributeResult> niftyModifyVpnGatewayAttributeAsync(final NiftyModifyVpnGatewayAttributeRequest request) {
		return executorService.submit(
				new Callable<NiftyModifyVpnGatewayAttributeResult>() {
					@Override
					public NiftyModifyVpnGatewayAttributeResult call() {
						return niftyModifyVpnGatewayAttribute(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyRebootVpnGatewaysAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysRequest)
	 */
	@Override
	public Future<NiftyRebootVpnGatewaysResult> niftyRebootVpnGatewaysAsync(final NiftyRebootVpnGatewaysRequest request) {
		return executorService.submit(
				new Callable<NiftyRebootVpnGatewaysResult>() {
					@Override
					public NiftyRebootVpnGatewaysResult call() {
						return niftyRebootVpnGateways(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyAssociateRouteTableWithVpnGatewayAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayRequest)
	 */
	@Override
	public Future<NiftyAssociateRouteTableWithVpnGatewayResult> niftyAssociateRouteTableWithVpnGatewayAsync(final NiftyAssociateRouteTableWithVpnGatewayRequest request) {
		return executorService.submit(
				new Callable<NiftyAssociateRouteTableWithVpnGatewayResult>() {
					@Override
					public NiftyAssociateRouteTableWithVpnGatewayResult call() {
						return niftyAssociateRouteTableWithVpnGateway(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyDisassociateRouteTableFromVpnGatewayAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayRequest)
	 */
	@Override
	public Future<NiftyDisassociateRouteTableFromVpnGatewayResult> niftyDisassociateRouteTableFromVpnGatewayAsync(final NiftyDisassociateRouteTableFromVpnGatewayRequest request) {
		return executorService.submit(
				new Callable<NiftyDisassociateRouteTableFromVpnGatewayResult>() {
					@Override
					public NiftyDisassociateRouteTableFromVpnGatewayResult call() {
						return niftyDisassociateRouteTableFromVpnGateway(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyReplaceRouteTableAssociationWithVpnGatewayAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayRequest)
	 */
	@Override
	public Future<NiftyReplaceRouteTableAssociationWithVpnGatewayResult> niftyReplaceRouteTableAssociationWithVpnGatewayAsync(final NiftyReplaceRouteTableAssociationWithVpnGatewayRequest request) {
		return executorService.submit(
				new Callable<NiftyReplaceRouteTableAssociationWithVpnGatewayResult>() {
					@Override
					public NiftyReplaceRouteTableAssociationWithVpnGatewayResult call() {
						return niftyReplaceRouteTableAssociationWithVpnGateway(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyReplaceVpnGatewayLatestVersionAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionRequest)
	 */
	@Override
	public Future<NiftyReplaceVpnGatewayLatestVersionResult> niftyReplaceVpnGatewayLatestVersionAsync(final NiftyReplaceVpnGatewayLatestVersionRequest request) {
		return executorService.submit(
				new Callable<NiftyReplaceVpnGatewayLatestVersionResult>() {
					@Override
					public NiftyReplaceVpnGatewayLatestVersionResult call() {
						return niftyReplaceVpnGatewayLatestVersion(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyRestoreVpnGatewayPreviousVersionAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionRequest)
	 */
	@Override
	public Future<NiftyRestoreVpnGatewayPreviousVersionResult> niftyRestoreVpnGatewayPreviousVersionAsync(final NiftyRestoreVpnGatewayPreviousVersionRequest request) {
		return executorService.submit(
				new Callable<NiftyRestoreVpnGatewayPreviousVersionResult>() {
					@Override
					public NiftyRestoreVpnGatewayPreviousVersionResult call() {
						return niftyRestoreVpnGatewayPreviousVersion(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyReleaseVpnGatewayBackupStateAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateRequest)
	 */
	@Override
	public Future<NiftyReleaseVpnGatewayBackupStateResult> niftyReleaseVpnGatewayBackupStateAsync(final NiftyReleaseVpnGatewayBackupStateRequest request) {
		return executorService.submit(
				new Callable<NiftyReleaseVpnGatewayBackupStateResult>() {
					@Override
					public NiftyReleaseVpnGatewayBackupStateResult call() {
						return niftyReleaseVpnGatewayBackupState(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpngateway.NiftyVpnGatewayAsync#niftyUpdateVpnGatewayNetworkInterfacesAsync(com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesRequest)
	 */
	@Override
	public Future<NiftyUpdateVpnGatewayNetworkInterfacesResult> niftyUpdateVpnGatewayNetworkInterfacesAsync(final NiftyUpdateVpnGatewayNetworkInterfacesRequest request) {
		return executorService.submit(
				new Callable<NiftyUpdateVpnGatewayNetworkInterfacesResult>() {
					@Override
					public NiftyUpdateVpnGatewayNetworkInterfacesResult call() {
						return niftyUpdateVpnGatewayNetworkInterfaces(request);
					}
				}
		);
	}
}