/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesResult;


/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * VPNゲートウェイカテゴリクライアント。<br />
 * VPNゲートウェイ カテゴリの非同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public interface NiftyVpnGatewayAsync extends NiftyVpnGateway {

	/**
	 * 非同期でVPNゲートウェイを新規作成します。
	 *
	 * @param request CreateVpnGatewayリクエスト<br />
	 * &nbsp;	CreateVpnGatewayRequest#typeは利用不可
	 * @return 非同期処理結果<br />
	 * &nbsp;	VpnGateway#typeは利用不可<br />
	 * &nbsp;	VpnGateway#attachmentsは利用不可
	 */
	public Future<CreateVpnGatewayResult> createVpnGatewayAsync(CreateVpnGatewayRequest request);


	/**
	 * 非同期で指定したVPNゲートウェイを削除します。
	 *
	 * @param request DeleteVpnGatewayリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DeleteVpnGatewayResult> deleteVpnGatewayAsync(DeleteVpnGatewayRequest request);


	/**
	 * 非同期でVPNゲートウェイの情報を取得します。
	 *
	 * @param request DescribeVpnGatewaysリクエスト
	 * @return 非同期処理結果<br />
	 * &nbsp;	VpnGateway#typeは利用不可<br />
	 * &nbsp;	VpnGateway#attachmentsは利用不可
	 */
	public Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync(DescribeVpnGatewaysRequest request);


	/**
	 * 非同期で指定したVPNゲートウェイの接続ログ情報を取得します。
	 *
	 * @param request NiftyDescribeVpnGatewayActivitiesリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDescribeVpnGatewayActivitiesResult> niftyDescribeVpnGatewayActivitiesAsync(NiftyDescribeVpnGatewayActivitiesRequest request);


	/**
	 * 非同期で指定したVPNゲートウェイの詳細情報を更新します。
	 *
	 * @param request NiftyModifyVpnGatewayAttributeリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyModifyVpnGatewayAttributeResult> niftyModifyVpnGatewayAttributeAsync(NiftyModifyVpnGatewayAttributeRequest request);


	/**
	 * 非同期で指定したVPNゲートウェイを再起動します。
	 *
	 * @param request NiftyRebootVpnGatewaysリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyRebootVpnGatewaysResult> niftyRebootVpnGatewaysAsync(NiftyRebootVpnGatewaysRequest request);


	/**
	 * 非同期で指定したルートテーブルを指定したVPNゲートウェイに設定します。
	 *
	 * @param request NiftyAssociateRouteTableWithVpnGatewayリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyAssociateRouteTableWithVpnGatewayResult> niftyAssociateRouteTableWithVpnGatewayAsync(NiftyAssociateRouteTableWithVpnGatewayRequest request);


	/**
	 * 非同期で指定したルートテーブルをVPNゲートウェイから解除します。
	 *
	 * @param request NiftyDisassociateRouteTableFromVpnGatewayリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDisassociateRouteTableFromVpnGatewayResult> niftyDisassociateRouteTableFromVpnGatewayAsync(NiftyDisassociateRouteTableFromVpnGatewayRequest request);


	/**
	 * 非同期でVPNゲートウェイに適用されたルートテーブルを解除し、指定したルートテーブルに入れ替えます。
	 *
	 * @param request NiftyReplaceRouteTableAssociationWithVpnGatewayリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReplaceRouteTableAssociationWithVpnGatewayResult> niftyReplaceRouteTableAssociationWithVpnGatewayAsync(NiftyReplaceRouteTableAssociationWithVpnGatewayRequest request);


	/**
	 * 非同期で指定したVPNゲートウェイを最新バージョンに入れ替えます。
	 *
	 * @param request NiftyReplaceVpnGatewayLatestVersionリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReplaceVpnGatewayLatestVersionResult> niftyReplaceVpnGatewayLatestVersionAsync(NiftyReplaceVpnGatewayLatestVersionRequest request);


	/**
	 * 非同期で指定したVPNゲートウェイの旧バージョンへの復元を実施します。
	 *
	 * @param request NiftyRestoreVpnGatewayPreviousVersionリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyRestoreVpnGatewayPreviousVersionResult> niftyRestoreVpnGatewayPreviousVersionAsync(NiftyRestoreVpnGatewayPreviousVersionRequest request);


	/**
	 * 非同期で指定したVPNゲートウェイのバックアップ状態を解除します。
	 *
	 * @param request NiftyReleaseVpnGatewayBackupStateリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReleaseVpnGatewayBackupStateResult> niftyReleaseVpnGatewayBackupStateAsync(NiftyReleaseVpnGatewayBackupStateRequest request);


	/**
	 * 非同期で指定したVPNゲートウェイのネットワーク設定を変更します。
	 *
	 * @param request NiftyUpdateVpnGatewayNetworkInterfacesリクエスト<br />
	 * &nbsp;	NetworkInterface#deviceIndexは利用不可<br />
	 * &nbsp;	NetworkInterface#groupIdsは利用不可<br />
	 * &nbsp;	NetworkInterface#networkIdは利用不可<br />
	 * &nbsp;	NetworkInterface#networkNameは利用不可<br />
	 * @return 非同期処理結果
	 */
	public Future<NiftyUpdateVpnGatewayNetworkInterfacesResult> niftyUpdateVpnGatewayNetworkInterfacesAsync(NiftyUpdateVpnGatewayNetworkInterfacesRequest request);
}