/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpngateway;

import com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.CreateVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.DeleteVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.DescribeVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyAssociateRouteTableWithVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDescribeVpnGatewayActivitiesResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyDisassociateRouteTableFromVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyModifyVpnGatewayAttributeResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRebootVpnGatewaysResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReleaseVpnGatewayBackupStateResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceRouteTableAssociationWithVpnGatewayResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyReplaceVpnGatewayLatestVersionResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyRestoreVpnGatewayPreviousVersionResult;
import com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesRequest;
import com.nifty.cloud.sdk.vpngateway.model.NiftyUpdateVpnGatewayNetworkInterfacesResult;


/**
 * NIFCLOUD API クライアント　インタフェース。
 * VPNゲートウェイ カテゴリ クライアント。<br />
 * VPNゲートウェイ カテゴリの同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public interface NiftyVpnGateway {

	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * VPNゲートウェイを新規作成します。
	 *
	 * @param request CreateVpnGatewayリクエスト<br />
	 * &nbsp;	CreateVpnGatewayRequest#typeは利用不可
	 * @return CreateVpnGateway処理結果<br />
	 * &nbsp;	VpnGateway#typeは利用不可<br />
	 * &nbsp;	VpnGateway#attachmentsは利用不可
	 */
	public CreateVpnGatewayResult createVpnGateway(CreateVpnGatewayRequest request);

	/**
	 * 指定したVPNゲートウェイを削除します。
	 *
	 * @param request DeleteVpnGatewayリクエスト
	 * @return DeleteVpnGateway処理結果
	 */
	public DeleteVpnGatewayResult deleteVpnGateway(DeleteVpnGatewayRequest request);

	/**
	 * VPNゲートウェイの情報を取得します。
	 *
	 * @param request DescribeVpnGatewaysリクエスト
	 * @return DescribeVpnGateways処理結果<br />
	 * &nbsp;	VpnGateway#typeは利用不可<br />
	 * &nbsp;	VpnGateway#attachmentsは利用不可
	 */
	public DescribeVpnGatewaysResult describeVpnGateways(DescribeVpnGatewaysRequest request);

	/**
	 * 指定したVPNゲートウェイの接続ログ情報を取得します。
	 *
	 * @param request NiftyDescribeVpnGatewayActivitiesリクエスト
	 * @return NiftyDescribeVpnGatewayActivities処理結果
	 */
	public NiftyDescribeVpnGatewayActivitiesResult niftyDescribeVpnGatewayActivities(NiftyDescribeVpnGatewayActivitiesRequest request);

	/**
	 * 指定したVPNゲートウェイの詳細情報を更新します。
	 *
	 * @param request NiftyModifyVpnGatewayAttributeリクエスト
	 * @return NiftyModifyVpnGatewayAttribute処理結果
	 */
	public NiftyModifyVpnGatewayAttributeResult niftyModifyVpnGatewayAttribute(NiftyModifyVpnGatewayAttributeRequest request);

	/**
	 * 指定したVPNゲートウェイを再起動します。
	 *
	 * @param request NiftyRebootVpnGatewaysリクエスト
	 * @return NiftyRebootVpnGateways処理結果
	 */
	public NiftyRebootVpnGatewaysResult niftyRebootVpnGateways(NiftyRebootVpnGatewaysRequest request);

	/**
	 * 指定したルートテーブルを指定したVPNゲートウェイに設定します。
	 *
	 * @param request NiftyAssociateRouteTableWithVpnGatewayリクエスト
	 * @return NiftyAssociateRouteTableWithVpnGateway処理結果
	 */
	public NiftyAssociateRouteTableWithVpnGatewayResult niftyAssociateRouteTableWithVpnGateway(NiftyAssociateRouteTableWithVpnGatewayRequest request);

	/**
	 * 指定したルートテーブルをVPNゲートウェイから解除します。
	 *
	 * @param request NiftyDisassociateRouteTableFromVpnGatewayリクエスト
	 * @return NiftyDisassociateRouteTableFromVpnGateway処理結果
	 */
	public NiftyDisassociateRouteTableFromVpnGatewayResult niftyDisassociateRouteTableFromVpnGateway(NiftyDisassociateRouteTableFromVpnGatewayRequest request);

	/**
	 * VPNゲートウェイに適用されたルートテーブルを解除し、指定したルートテーブルに入れ替えます。
	 *
	 * @param request NiftyReplaceRouteTableAssociationWithVpnGatewayリクエスト
	 * @return NiftyReplaceRouteTableAssociationWithVpnGateway処理結果
	 */
	public NiftyReplaceRouteTableAssociationWithVpnGatewayResult niftyReplaceRouteTableAssociationWithVpnGateway(NiftyReplaceRouteTableAssociationWithVpnGatewayRequest request);

	/**
	 * 指定したVPNゲートウェイを最新バージョンに入れ替えます。
	 *
	 * @param request NiftyReplaceVpnGatewayLatestVersionリクエスト
	 * @return NiftyReplaceVpnGatewayLatestVersion処理結果
	 */
	public NiftyReplaceVpnGatewayLatestVersionResult niftyReplaceVpnGatewayLatestVersion(NiftyReplaceVpnGatewayLatestVersionRequest request);

	/**
	 * 指定したVPNゲートウェイの旧バージョンへの復元を実施します。
	 *
	 * @param request NiftyRestoreVpnGatewayPreviousVersionリクエスト
	 * @return NiftyRestoreVpnGatewayPreviousVersion処理結果
	 */
	public NiftyRestoreVpnGatewayPreviousVersionResult niftyRestoreVpnGatewayPreviousVersion(NiftyRestoreVpnGatewayPreviousVersionRequest request);

	/**
	 * 指定したVPNゲートウェイのバックアップ状態を解除します。
	 *
	 * @param request NiftyReleaseVpnGatewayBackupStateリクエスト
	 * @return NiftyReleaseVpnGatewayBackupState処理結果
	 */
	public NiftyReleaseVpnGatewayBackupStateResult niftyReleaseVpnGatewayBackupState(NiftyReleaseVpnGatewayBackupStateRequest request);

	/**
	 * 指定したVPNゲートウェイのネットワーク設定を変更します。
	 *
	 * @param request NiftyUpdateVpnGatewayNetworkInterfacesリクエスト<br />
	 * &nbsp;	NetworkInterface#deviceIndexは利用不可<br />
	 * &nbsp;	NetworkInterface#groupIdsは利用不可<br />
	 * &nbsp;	NetworkInterface#networkIdは利用不可<br />
	 * &nbsp;	NetworkInterface#networkNameは利用不可<br />
	 * @return NiftyUpdateVpnGatewayNetworkInterfaces処理結果
	 */
	public NiftyUpdateVpnGatewayNetworkInterfacesResult niftyUpdateVpnGatewayNetworkInterfaces(NiftyUpdateVpnGatewayNetworkInterfacesRequest request);
}