/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.tools.DateUtils;
import com.nifty.cloud.sdk.vpnconnection.model.NiftyIpsecConfiguration;
import com.nifty.cloud.sdk.vpnconnection.model.NiftyTunnel;
import com.nifty.cloud.sdk.vpnconnection.model.Tag;
import com.nifty.cloud.sdk.vpnconnection.model.VgwTelemetry;
import com.nifty.cloud.sdk.vpnconnection.model.VpnConnection;
import com.nifty.cloud.sdk.vpnconnection.model.VpnConnectionOptions;
import com.nifty.cloud.sdk.vpnconnection.model.VpnStaticRoutes;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * VpnConnectionSetType変換クラス。<br />
 * このクラスはレスポンスXMLのvpnConnectionSet要素からVpnConnectionクラスのリストを生成します。
 */
public class VpnConnectionSetConverter implements Converter {

	private static final String ELEMENT_VPN_CONNECTION_ID = "vpnConnectionId";
	private static final String ELEMENT_STATE = "state";
	private static final String ELEMENT_CUSTOMER_GATEWAY_CONFIGURATION = "customerGatewayConfiguration";
	private static final String ELEMENT_TYPE = "type";
	private static final String ELEMENT_VPN_GATEWAY_ID = "vpnGatewayId";
	private static final String ELEMENT_NIFTY_VPN_GATEWAY_NAME = "niftyVpnGatewayName";
	private static final String ELEMENT_CUSTOMER_GATEWAY_ID = "customerGatewayId";
	private static final String ELEMENT_NIFTY_CUSTOMER_GATEWAY_NAME = "niftyCustomerGatewayName";
	private static final String ELEMENT_TAG_SET = "tagSet";
	private static final String ELEMENT_VGW_TELEMETRY = "vgwTelemetry";
	private static final String ELEMENT_OPTIONS = "options";
	private static final String ELEMENT_ROUTES = "routes";
	private static final String ELEMENT_NIFTY_VPN_CONNECTION_DESCRIPTION = "niftyVpnConnectionDescription";
	private static final String ELEMENT_CREATED_TIME = "createdTime";
	private static final String ELEMENT_NIFTY_TUNNEL = "niftyTunnel";
	private static final String ELEMENT_NIFTY_IPSEC_CONFIGURATION = "niftyIpsecConfiguration";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * vpnConnectionSetをList<VpnConnection>に変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<VpnConnection>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<VpnConnection> vpnConnections = new ArrayList<VpnConnection>();
		Converter tagSetConverter = new TagSetConverter();
		Converter vgwTelemetryConverter = new VgwTelemetryConverter();
		Converter optionsConverter = new OptionsConverter();
		Converter routesConverter = new RoutesConverter();
		Converter niftyTunnelConverter = new NiftyTunnelConverter();
		Converter niftyIpsecConfigurationConverter = new NiftyIpsecConfigurationConverter();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();
			VpnConnection vpnConnection = new VpnConnection();

			while (reader.hasMoreChildren()) {
				reader.moveDown();

				name = reader.getNodeName();
				if (name.equals(ELEMENT_VPN_CONNECTION_ID)) {
					vpnConnection.setVpnConnectionId(reader.getValue());
				} else if (name.equals(ELEMENT_STATE)) {
					vpnConnection.setState(reader.getValue());
				} else if (name.equals(ELEMENT_CUSTOMER_GATEWAY_CONFIGURATION)) {
					vpnConnection.setCustomerGatewayConfiguration(reader.getValue());
				} else if (name.equals(ELEMENT_TYPE)) {
					vpnConnection.setType(reader.getValue());
				} else if (name.equals(ELEMENT_VPN_GATEWAY_ID)) {
					vpnConnection.setVpnGatewayId(reader.getValue());
				} else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_NAME)) {
					vpnConnection.setNiftyVpnGatewayName(reader.getValue());
				} else if (name.equals(ELEMENT_CUSTOMER_GATEWAY_ID)) {
					vpnConnection.setCustomerGatewayId(reader.getValue());
				} else if (name.equals(ELEMENT_NIFTY_CUSTOMER_GATEWAY_NAME)) {
					vpnConnection.setNiftyCustomerGatewayName(reader.getValue());
				} else if (name.equals(ELEMENT_TAG_SET)) {
					vpnConnection.setTagSet((List<Tag>) tagSetConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_VGW_TELEMETRY)) {
					vpnConnection.setVgwTelemetries((List<VgwTelemetry>) vgwTelemetryConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_OPTIONS)) {
					vpnConnection.setOptions((VpnConnectionOptions) optionsConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_ROUTES)) {
					vpnConnection.setRoutes((VpnStaticRoutes) routesConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_NIFTY_VPN_CONNECTION_DESCRIPTION)) {
					vpnConnection.setNiftyVpnConnectionDescription(reader.getValue());
				} else if (name.equals(ELEMENT_CREATED_TIME)) {
					vpnConnection.setCreatedTime(DateUtils.toDate(reader.getValue()));
				} else if (name.equals(ELEMENT_NIFTY_TUNNEL)) {
					vpnConnection.setNiftyTunnel((NiftyTunnel) niftyTunnelConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_NIFTY_IPSEC_CONFIGURATION)) {
					vpnConnection.setNiftyIpsecConfiguration((NiftyIpsecConfiguration) niftyIpsecConfigurationConverter.unmarshal(reader, context));
				}
				reader.moveUp();
			}
			reader.moveUp();
			vpnConnections.add(vpnConnection);
		}
		return vpnConnections;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
