/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.tools.DateUtils;
import com.nifty.cloud.sdk.vpnconnection.model.VgwTelemetry;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * VpnTunnelTelemetryType変換クラス。<br />
 * このクラスはレスポンスXMLのvgwTelemetry要素からVgwTelemetryクラスのリストを生成します。
 */
public class VgwTelemetryConverter implements Converter {

	private static final String ELEMENT_OUTSIDE_IP_ADDRESS = "outsideIpAddress";
	private static final String ELEMENT_STATUS = "status";
	private static final String ELEMENT_LAST_STATUS_CHANGE = "lastStatusChange";
	private static final String ELEMENT_STATUS_MESSAGE = "statusMessage";
	private static final String ELEMENT_ACCEPTED_ROUTE_COUNT = "acceptedRouteCount";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * vgwTelemetryをList<VgwTelemetry>に変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<VgwTelemetry>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<VgwTelemetry> vgwTelemetries = new ArrayList<VgwTelemetry>();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();
			VgwTelemetry vgwTelemetry = new VgwTelemetry();

			while(reader.hasMoreChildren()) {

				reader.moveDown();
				name = reader.getNodeName();
				if (name.equals(ELEMENT_OUTSIDE_IP_ADDRESS)) {
					vgwTelemetry.setOutsideIpAddress(reader.getValue());
				} else if (name.equals(ELEMENT_STATUS)) {
					vgwTelemetry.setStatus(reader.getValue());
				} else if (name.equals(ELEMENT_LAST_STATUS_CHANGE)) {
					vgwTelemetry.setLastStatusChange(DateUtils.toDate(reader.getValue()));
				} else if (name.equals(ELEMENT_STATUS_MESSAGE)) {
					vgwTelemetry.setStatusMessage(reader.getValue());
				} else if (name.equals(ELEMENT_ACCEPTED_ROUTE_COUNT)) {
					vgwTelemetry.setAcceptedRouteCount(new Integer(reader.getValue()));
				}
				reader.moveUp();
			}
			reader.moveUp();
			vgwTelemetries.add(vgwTelemetry);
		}
		return vgwTelemetries;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
