/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model.transform;

import com.nifty.cloud.sdk.vpnconnection.model.NiftyTunnel;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NiftyTunnelType変換クラス。<br />
 * このクラスはレスポンスXMLのniftyTunnel要素からNiftyTunnelクラスを生成します。
 */
public class NiftyTunnelConverter implements Converter {

	private static final String ELEMENT_TYPE = "type";
	private static final String ELEMENT_MODE = "mode";
	private static final String ELEMENT_ENCAPSULATION = "encapsulation";
	private static final String ELEMENT_TUNNEL_ID = "tunnelId";
	private static final String ELEMENT_PEER_TUNNEL_ID = "peerTunnelId";
	private static final String ELEMENT_SESSION_ID = "sessionId";
	private static final String ELEMENT_PEER_SESSION_ID = "peerSessionId";
	private static final String ELEMENT_SOURCE_PORT = "sourcePort";
	private static final String ELEMENT_DESTINATION_PORT = "destinationPort";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == NiftyTunnel.class;
	}

	/**
	 * {@literal
	 * niftyTunnelをNiftyTunnelクラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal NiftyTunnelオブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		NiftyTunnel niftyTunnel = new NiftyTunnel();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();

			name = reader.getNodeName();
			if (name.equals(ELEMENT_TYPE)) {
				niftyTunnel.setType(reader.getValue());
			} else if (name.equals(ELEMENT_MODE)) {
				niftyTunnel.setMode(reader.getValue());
			} else if (name.equals(ELEMENT_ENCAPSULATION)) {
				niftyTunnel.setEncapsulation(reader.getValue());
			} else if (name.equals(ELEMENT_TUNNEL_ID)) {
				niftyTunnel.setTunnelId(reader.getValue());
			} else if (name.equals(ELEMENT_PEER_TUNNEL_ID)) {
				niftyTunnel.setPeerTunnelId(reader.getValue());
			} else if (name.equals(ELEMENT_SESSION_ID)) {
				niftyTunnel.setSessionId(reader.getValue());
			} else if (name.equals(ELEMENT_PEER_SESSION_ID)) {
				niftyTunnel.setPeerSessionId(reader.getValue());
			} else if (name.equals(ELEMENT_SOURCE_PORT)) {
				niftyTunnel.setSourcePort(reader.getValue());
			} else if (name.equals(ELEMENT_DESTINATION_PORT)) {
				niftyTunnel.setDestinationPort(reader.getValue());
			}

			reader.moveUp();
		}

		return niftyTunnel;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
