/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model.transform;

import com.nifty.cloud.sdk.vpnconnection.model.NiftyIpsecConfiguration;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NiftyIpsecConfigurationType変換クラス。<br />
 * このクラスはレスポンスXMLのniftyIpsecConfiguration要素からNiftyIpsecConfigurationクラスを生成します。
 */
public class NiftyIpsecConfigurationConverter implements Converter {

	private static final String ELEMENT_ENCRYPTION_ALGORITHM = "encryptionAlgorithm";
	private static final String ELEMENT_HASHING_ALGORITHM = "hashingAlgorithm";
	private static final String ELEMENT_MTU = "mtu";
	private static final String ELEMENT_PRE_SHARED_KEY = "preSharedKey";
	private static final String ELEMENT_INTERNET_KEY_EXCHANGE = "internetKeyExchange";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == NiftyIpsecConfiguration.class;
	}

	/**
	 * {@literal
	 * niftyIpsecConfigurationをNiftyIpsecConfigurationクラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal NiftyIpsecConfigurationオブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		NiftyIpsecConfiguration niftyIpsecConfiguration = new NiftyIpsecConfiguration();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();

			name = reader.getNodeName();
			if (name.equals(ELEMENT_ENCRYPTION_ALGORITHM)) {
				niftyIpsecConfiguration.setEncryptionAlgorithm(reader.getValue());
			} else if (name.equals(ELEMENT_HASHING_ALGORITHM)) {
				niftyIpsecConfiguration.setHashingAlgorithm(reader.getValue());
			} else if (name.equals(ELEMENT_MTU)) {
				niftyIpsecConfiguration.setMtu(reader.getValue());
			} else if (name.equals(ELEMENT_PRE_SHARED_KEY)) {
				niftyIpsecConfiguration.setPreSharedKey(reader.getValue());
			} else if (name.equals(ELEMENT_INTERNET_KEY_EXCHANGE)) {
				niftyIpsecConfiguration.setInternetKeyExchange(reader.getValue());
			}

			reader.moveUp();
		}

		return niftyIpsecConfiguration;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
