/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

/**
 * VPNコネクションに対する静的ルーティングクラス。<br />
 * このクラスはVPNコネクションに対する静的ルーティングを格納します。
 *
 */
public class VpnStaticRoutes {

	/** 宛先CIDRブロック */
	private String destinationCidrBlock;

	/** ルーティングの種別 */
	private String source;

	/** 静的ルーティングのステータス */
	private String state;

	/**
	 * 宛先CIDRブロックを取得します。
	 *
	 * @return 宛先CIDRブロック
	 */
	public String getDestinationCidrBlock() {
		return destinationCidrBlock;
	}

	/**
	 * 宛先CIDRブロックを設定します。
	 *
	 * @param destinationCidrBlock 宛先CIDRブロック
	 */
	public void setDestinationCidrBlock(String destinationCidrBlock) {
		this.destinationCidrBlock = destinationCidrBlock;
	}

	/**
	 * 宛先CIDRブロックを設定し、自オブジェクトを返します。
	 *
	 * @param destinationCidrBlock 宛先CIDRブロック
	 * @return 自オブジェクト
	 */
	public VpnStaticRoutes withDestinationCidrBlock(String destinationCidrBlock) {
		setDestinationCidrBlock(destinationCidrBlock);
		return this;
	}

	/**
	 * ルーティングの種別を取得します。
	 *
	 * @return ルーティングの種別
	 */
	public String getSource() {
		return source;
	}

	/**
	 * ルーティングの種別を設定します。
	 *
	 * @param source ルーティングの種別
	 */
	public void setSource(String source) {
		this.source = source;
	}

	/**
	 * ルーティングの種別を設定し、自オブジェクトを返します。
	 *
	 * @param source ルーティングの種別
	 * @return 自オブジェクト
	 */
	public VpnStaticRoutes withSource(String source) {
		setSource(source);
		return this;
	}

	/**
	 * 静的ルーティングのステータスを取得します。
	 *
	 * @return 静的ルーティングのステータス
	 */
	public String getState() {
		return state;
	}

	/**
	 * 静的ルーティングのステータスを設定します。
	 *
	 * @param state 静的ルーティングのステータス
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * 静的ルーティングのステータスを設定し、自オブジェクトを返します。
	 *
	 * @param state 静的ルーティングのステータス
	 * @return 自オブジェクト
	 */
	public VpnStaticRoutes withState(String state) {
		setState(state);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[destinationCidrBlock=");
		builder.append(destinationCidrBlock);
		builder.append(", source=");
		builder.append(source);
		builder.append(", state=");
		builder.append(state);
		builder.append("]");
		return builder.toString();
	}
}
