/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

/**
 * VPNコネクションオプションクラス。<br />
 * このクラスはVPNコネクションオプションを格納します。
 *
 */
public class VpnConnectionOptions {

	/** スタティックルーティングの使用可否 */
	private Boolean staticRoutesOnly;

	/**
	 * スタティックルーティングの使用可否を取得します。
	 *
	 * @return スタティックルーティングの使用可否
	 */
	public Boolean getStaticRoutesOnly() {
		return staticRoutesOnly;
	}

	/**
	 * スタティックルーティングの使用可否を設定します。
	 *
	 * @param staticRoutesOnly スタティックルーティングの使用可否
	 */
	public void setStaticRoutesOnly(Boolean staticRoutesOnly) {
		this.staticRoutesOnly = staticRoutesOnly;
	}

	/**
	 * スタティックルーティングの使用可否を設定し、自オブジェクトを返します。
	 *
	 * @param staticRoutesOnly スタティックルーティングの使用可否
	 * @return 自オブジェクト
	 */
	public VpnConnectionOptions withStaticRoutesOnly(Boolean staticRoutesOnly) {
		setStaticRoutesOnly(staticRoutesOnly);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[staticRoutesOnly=");
		builder.append(staticRoutesOnly);
		builder.append("]");
		return builder.toString();
	}
}
