/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * VPNコネクション情報クラス。<br />
 * このクラスはVPNコネクション情報を格納します。
 *
 */
public class VpnConnectionIdSet {

	/** VPNコネクションユニークID */
	private String vpnConnectionId;

	/**
	 * VPNコネクションユニークIDを取得します。
	 *
	 * @return VPNコネクションユニークID
	 */
	@Query(name="VpnConnectionId", reverseSequence=true)
	public String getVpnConnectionId() {
		return vpnConnectionId;
	}

	/**
	 * VPNコネクションユニークIDを設定します。
	 *
	 * @param vpnConnectionId VPNコネクションユニークID
	 */
	public void setVpnConnectionId(String vpnConnectionId) {
		this.vpnConnectionId = vpnConnectionId;
	}

	/**
	 * VPNコネクションユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnConnectionId VPNコネクションユニークID
	 * @return 自オブジェクト
	 */
	public VpnConnectionIdSet withVpnConnectionId(String vpnConnectionId) {
		setVpnConnectionId(vpnConnectionId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnConnectionId=");
		builder.append(vpnConnectionId);
		builder.append("]");
		return builder.toString();
	}
}
