/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * VPNコネクション情報クラス。<br />
 * このクラスはVPNコネクション情報を格納します。
 *
 */
public class VpnConnection {

	/** VPNコネクションユニークID */
	private String vpnConnectionId;

	/** VPNコネクションステータス */
	private String state;

	/** カスタマーゲートウェイに設定する情報(xml形式) */
	private String customerGatewayConfiguration;

	/** VPNコネクションタイプ */
	private String type;

	/** VPNゲートウェイユニークID */
	private String vpnGatewayId;

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	/** カスタマーゲートウェイユニークID */
	private String customerGatewayId;

	/** カスタマーゲートウェイ名 */
	private String niftyCustomerGatewayName;

	/** リソースに設定されているタグ情報 */
	private List<Tag> tagSet;

	/** VPNゲートウェイ情報 */
	private List<VgwTelemetry> vgwTelemetries;

	/** VPNコネクションオプション */
	private VpnConnectionOptions options;

	/** VPNコネクションに対する静的ルーティング */
	private VpnStaticRoutes routes;

	/** メモ */
	private String niftyVpnConnectionDescription;

	/** 作成日時 */
	private Date createdTime;

	/** トンネル情報 */
	private NiftyTunnel niftyTunnel;

	/** 設定情報 */
	private NiftyIpsecConfiguration niftyIpsecConfiguration;

	/**
	 * VPNコネクションユニークIDを取得します。
	 *
	 * @return VPNコネクションユニークID
	 */
	public String getVpnConnectionId() {
		return vpnConnectionId;
	}

	/**
	 * VPNコネクションユニークIDを設定します。
	 *
	 * @param vpnConnectionId VPNコネクションユニークID
	 */
	public void setVpnConnectionId(String vpnConnectionId) {
		this.vpnConnectionId = vpnConnectionId;
	}

	/**
	 * VPNコネクションユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnConnectionId VPNコネクションユニークID
	 * @return 自オブジェクト
	 */
	public VpnConnection withVpnConnectionId(String vpnConnectionId) {
		setVpnConnectionId(vpnConnectionId);
		return this;
	}

	/**
	 * VPNコネクションステータスを取得します。
	 *
	 * @return VPNコネクションステータス
	 */
	public String getState() {
		return state;
	}

	/**
	 * VPNコネクションステータスを設定します。
	 *
	 * @param state VPNコネクションステータス
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * VPNコネクションステータスを設定し、自オブジェクトを返します。
	 *
	 * @param state VPNコネクションステータス
	 * @return 自オブジェクト
	 */
	public VpnConnection withState(String state) {
		setState(state);
		return this;
	}

	/**
	 * カスタマーゲートウェイに設定する情報(xml形式)を取得します。
	 *
	 * @return カスタマーゲートウェイに設定する情報(xml形式)
	 */
	public String getCustomerGatewayConfiguration() {
		return customerGatewayConfiguration;
	}

	/**
	 * カスタマーゲートウェイに設定する情報(xml形式)を設定します。
	 *
	 * @param customerGatewayConfiguration カスタマーゲートウェイに設定する情報(xml形式)
	 */
	public void setCustomerGatewayConfiguration(String customerGatewayConfiguration) {
		this.customerGatewayConfiguration = customerGatewayConfiguration;
	}

	/**
	 * カスタマーゲートウェイに設定する情報(xml形式)を設定し、自オブジェクトを返します。
	 *
	 * @param customerGatewayConfiguration カスタマーゲートウェイに設定する情報(xml形式)
	 * @return 自オブジェクト
	 */
	public VpnConnection withCustomerGatewayConfiguration(String customerGatewayConfiguration) {
		setCustomerGatewayConfiguration(customerGatewayConfiguration);
		return this;
	}

	/**
	 * VPNコネクションタイプを取得します。
	 *
	 * @return VPNコネクションタイプ
	 */
	public String getType() {
		return type;
	}

	/**
	 * VPNコネクションタイプを設定します。
	 *
	 * @param type VPNコネクションタイプ
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * VPNコネクションタイプを設定し、自オブジェクトを返します。
	 *
	 * @param type VPNコネクションタイプ
	 * @return 自オブジェクト
	 */
	public VpnConnection withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * VPNゲートウェイユニークIDを取得します。
	 *
	 * @return VPNゲートウェイユニークID
	 */
	public String getVpnGatewayId() {
		return vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 */
	public void setVpnGatewayId(String vpnGatewayId) {
		this.vpnGatewayId = vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public VpnConnection withVpnGatewayId(String vpnGatewayId) {
		setVpnGatewayId(vpnGatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	public String getNiftyVpnGatewayName() {
		return niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
		this.niftyVpnGatewayName = niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public VpnConnection withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * カスタマーゲートウェイユニークIDを取得します。
	 *
	 * @return カスタマーゲートウェイユニークID
	 */
	public String getCustomerGatewayId() {
		return customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 */
	public void setCustomerGatewayId(String customerGatewayId) {
		this.customerGatewayId = customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public VpnConnection withCustomerGatewayId(String customerGatewayId) {
		setCustomerGatewayId(customerGatewayId);
		return this;
	}

	/**
	 * カスタマーゲートウェイ名を取得します。
	 *
	 * @return カスタマーゲートウェイ名
	 */
	public String getNiftyCustomerGatewayName() {
		return niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 */
	public void setNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		this.niftyCustomerGatewayName = niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 * @return 自オブジェクト
	 */
	public VpnConnection withNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		setNiftyCustomerGatewayName(niftyCustomerGatewayName);
		return this;
	}

	/**
	 * リソースに設定されているタグ情報を取得します。
	 *
	 * @return リソースに設定されているタグ情報
	 */
	public List<Tag> getTagSet() {
		return tagSet;
	}

	/**
	 * リソースに設定されているタグ情報を設定します。
	 *
	 * @param tagSet リソースに設定されているタグ情報
	 */
	public void setTagSet(List<Tag> tagSet) {
		this.tagSet = tagSet;
	}

	/**
	 * リソースに設定されているタグ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報の配列
	 * @return 自オブジェクト
	 */
	public VpnConnection withTagSet(Tag ... tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		for (Tag tag : tagSet) {
			getTagSet().add(tag);
		}
		return this;
	}

	/**
	 * リソースに設定されているタグ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報リスト
	 * @return 自オブジェクト
	 */
	public VpnConnection withTagSet(Collection<Tag> tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		if (tagSet != null) {
			getTagSet().addAll(tagSet);
		}
		return this;
	}

	/**
	 * VPNゲートウェイ情報を取得します。
	 *
	 * @return VPNゲートウェイ情報
	 */
	public List<VgwTelemetry> getVgwTelemetries() {
		return vgwTelemetries;
	}

	/**
	 * VPNゲートウェイ情報を設定します。
	 *
	 * @param vgwTelemetries VPNゲートウェイ情報
	 */
	public void setVgwTelemetries(List<VgwTelemetry> vgwTelemetries) {
		this.vgwTelemetries = vgwTelemetries;
	}

	/**
	 * VPNゲートウェイ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param vgwTelemetries VPNゲートウェイ情報の配列
	 * @return 自オブジェクト
	 */
	public VpnConnection withVgwTelemetries(VgwTelemetry ... vgwTelemetries) {
		if (this.vgwTelemetries == null) this.vgwTelemetries = new ArrayList<VgwTelemetry>();
		for (VgwTelemetry vgwTelemetry : vgwTelemetries) {
			getVgwTelemetries().add(vgwTelemetry);
		}
		return this;
	}

	/**
	 * VPNゲートウェイ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param vgwTelemetries VPNゲートウェイ情報リスト
	 * @return 自オブジェクト
	 */
	public VpnConnection withVgwTelemetries(Collection<VgwTelemetry> vgwTelemetries) {
		if (this.vgwTelemetries == null) this.vgwTelemetries = new ArrayList<VgwTelemetry>();
		if (vgwTelemetries != null) {
			getVgwTelemetries().addAll(vgwTelemetries);
		}
		return this;
	}

	/**
	 * VPNコネクションオプションを取得します。
	 *
	 * @return VPNコネクションオプション
	 */
	public VpnConnectionOptions getOptions() {
		return options;
	}

	/**
	 * VPNコネクションオプションを設定します。
	 *
	 * @param options VPNコネクションオプション
	 */
	public void setOptions(VpnConnectionOptions options) {
		this.options = options;
	}

	/**
	 * VPNコネクションオプションを設定し、自オブジェクトを返します。
	 *
	 * @param options VPNコネクションオプション
	 * @return 自オブジェクト
	 */
	public VpnConnection withOptions(VpnConnectionOptions options) {
		setOptions(options);
		return this;
	}

	/**
	 * VPNコネクションに対する静的ルーティングを取得します。
	 *
	 * @return VPNコネクションに対する静的ルーティング
	 */
	public VpnStaticRoutes getRoutes() {
		return routes;
	}

	/**
	 * VPNコネクションに対する静的ルーティングを設定します。
	 *
	 * @param routes VPNコネクションに対する静的ルーティング
	 */
	public void setRoutes(VpnStaticRoutes routes) {
		this.routes = routes;
	}

	/**
	 * VPNコネクションに対する静的ルーティングを設定し、自オブジェクトを返します。
	 *
	 * @param routes VPNコネクションに対する静的ルーティング
	 * @return 自オブジェクト
	 */
	public VpnConnection withRoutes(VpnStaticRoutes routes) {
		setRoutes(routes);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	public String getNiftyVpnConnectionDescription() {
		return niftyVpnConnectionDescription;
	}

	/**
	 * メモを設定します。
	 *
	 * @param niftyVpnConnectionDescription メモ
	 */
	public void setNiftyVpnConnectionDescription(String niftyVpnConnectionDescription) {
		this.niftyVpnConnectionDescription = niftyVpnConnectionDescription;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnConnectionDescription メモ
	 * @return 自オブジェクト
	 */
	public VpnConnection withNiftyVpnConnectionDescription(String niftyVpnConnectionDescription) {
		setNiftyVpnConnectionDescription(niftyVpnConnectionDescription);
		return this;
	}

	/**
	 * 作成日時を取得します。
	 *
	 * @return 作成日時
	 */
	public Date getCreatedTime() {
		return createdTime;
	}

	/**
	 * 作成日時を設定します。
	 *
	 * @param createdTime 作成日時
	 */
	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	/**
	 * 作成日時を設定し、自オブジェクトを返します。
	 *
	 * @param createdTime 作成日時
	 * @return 自オブジェクト
	 */
	public VpnConnection withCreatedTime(Date createdTime) {
		setCreatedTime(createdTime);
		return this;
	}

	/**
	 * トンネル情報を取得します。
	 *
	 * @return トンネル情報
	 */
	public NiftyTunnel getNiftyTunnel() {
		return niftyTunnel;
	}

	/**
	 * トンネル情報を設定します。
	 *
	 * @param niftyTunnel トンネル情報
	 */
	public void setNiftyTunnel(NiftyTunnel niftyTunnel) {
		this.niftyTunnel = niftyTunnel;
	}

	/**
	 * トンネル情報を設定し、自オブジェクトを返します。
	 *
	 * @param niftyTunnel トンネル情報
	 * @return 自オブジェクト
	 */
	public VpnConnection withNiftyTunnel(NiftyTunnel niftyTunnel) {
		setNiftyTunnel(niftyTunnel);
		return this;
	}

	/**
	 * 設定情報を取得します。
	 *
	 * @return 設定情報
	 */
	public NiftyIpsecConfiguration getNiftyIpsecConfiguration() {
		return niftyIpsecConfiguration;
	}

	/**
	 * 設定情報を設定します。
	 *
	 * @param niftyIpsecConfiguration 設定情報
	 */
	public void setNiftyIpsecConfiguration(NiftyIpsecConfiguration niftyIpsecConfiguration) {
		this.niftyIpsecConfiguration = niftyIpsecConfiguration;
	}

	/**
	 * 設定情報を設定し、自オブジェクトを返します。
	 *
	 * @param niftyIpsecConfiguration 設定情報
	 * @return 自オブジェクト
	 */
	public VpnConnection withNiftyIpsecConfiguration(NiftyIpsecConfiguration niftyIpsecConfiguration) {
		setNiftyIpsecConfiguration(niftyIpsecConfiguration);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnConnectionId=");
		builder.append(vpnConnectionId);
		builder.append(", state=");
		builder.append(state);
		builder.append(", customerGatewayConfiguration=");
		builder.append(customerGatewayConfiguration);
		builder.append(", type=");
		builder.append(type);
		builder.append(", vpnGatewayId=");
		builder.append(vpnGatewayId);
		builder.append(", niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", customerGatewayId=");
		builder.append(customerGatewayId);
		builder.append(", niftyCustomerGatewayName=");
		builder.append(niftyCustomerGatewayName);
		builder.append(", tagSet=");
		builder.append(tagSet);
		builder.append(", vgwTelemetries=");
		builder.append(vgwTelemetries);
		builder.append(", options=");
		builder.append(options);
		builder.append(", routes=");
		builder.append(routes);
		builder.append(", niftyVpnConnectionDescription=");
		builder.append(niftyVpnConnectionDescription);
		builder.append(", createdTime=");
		builder.append(createdTime);
		builder.append(", niftyTunnel=");
		builder.append(niftyTunnel);
		builder.append(", niftyIpsecConfiguration=");
		builder.append(niftyIpsecConfiguration);
		builder.append("]");
		return builder.toString();
	}
}
