/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import java.util.Date;

/**
 * VPNゲートウェイ情報クラス。<br />
 * このクラスはVPNゲートウェイ情報を格納します。
 *
 */
public class VgwTelemetry {

	/** VPNゲートウェイのインターネット側IPアドレス */
	private String outsideIpAddress;

	/** VPNの接続ステータス */
	private String status;

	/** ステータス最終取得日 */
	private Date lastStatusChange;

	/** エラーが出ていた場合のメッセージ */
	private String statusMessage;

	/** 設定されたルート数 */
	private Integer acceptedRouteCount;

	/**
	 * VPNゲートウェイのインターネット側IPアドレスを取得します。
	 *
	 * @return VPNゲートウェイのインターネット側IPアドレス
	 */
	public String getOutsideIpAddress() {
		return outsideIpAddress;
	}

	/**
	 * VPNゲートウェイのインターネット側IPアドレスを設定します。
	 *
	 * @param outsideIpAddress VPNゲートウェイのインターネット側IPアドレス
	 */
	public void setOutsideIpAddress(String outsideIpAddress) {
		this.outsideIpAddress = outsideIpAddress;
	}

	/**
	 * VPNゲートウェイのインターネット側IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param outsideIpAddress VPNゲートウェイのインターネット側IPアドレス
	 * @return 自オブジェクト
	 */
	public VgwTelemetry withOutsideIpAddress(String outsideIpAddress) {
		setOutsideIpAddress(outsideIpAddress);
		return this;
	}

	/**
	 * VPNの接続ステータスを取得します。
	 *
	 * @return VPNの接続ステータス
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * VPNの接続ステータスを設定します。
	 *
	 * @param status VPNの接続ステータス
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * VPNの接続ステータスを設定し、自オブジェクトを返します。
	 *
	 * @param status VPNの接続ステータス
	 * @return 自オブジェクト
	 */
	public VgwTelemetry withStatus(String status) {
		setStatus(status);
		return this;
	}

	/**
	 * ステータス最終取得日を取得します。
	 *
	 * @return ステータス最終取得日
	 */
	public Date getLastStatusChange() {
		return lastStatusChange;
	}

	/**
	 * ステータス最終取得日を設定します。
	 *
	 * @param lastStatusChange ステータス最終取得日
	 */
	public void setLastStatusChange(Date lastStatusChange) {
		this.lastStatusChange = lastStatusChange;
	}

	/**
	 * ステータス最終取得日を設定し、自オブジェクトを返します。
	 *
	 * @param lastStatusChange ステータス最終取得日
	 * @return 自オブジェクト
	 */
	public VgwTelemetry withLastStatusChange(Date lastStatusChange) {
		setLastStatusChange(lastStatusChange);
		return this;
	}

	/**
	 * エラーが出ていた場合のメッセージを取得します。
	 *
	 * @return エラーが出ていた場合のメッセージ
	 */
	public String getStatusMessage() {
		return statusMessage;
	}

	/**
	 * エラーが出ていた場合のメッセージを設定します。
	 *
	 * @param statusMessage エラーが出ていた場合のメッセージ
	 */
	public void setStatusMessage(String statusMessage) {
		this.statusMessage = statusMessage;
	}

	/**
	 * エラーが出ていた場合のメッセージを設定し、自オブジェクトを返します。
	 *
	 * @param statusMessage エラーが出ていた場合のメッセージ
	 * @return 自オブジェクト
	 */
	public VgwTelemetry withStatusMessage(String statusMessage) {
		setStatusMessage(statusMessage);
		return this;
	}

	/**
	 * 設定されたルート数を取得します。
	 *
	 * @return 設定されたルート数
	 */
	public Integer getAcceptedRouteCount() {
		return acceptedRouteCount;
	}

	/**
	 * 設定されたルート数を設定します。
	 *
	 * @param acceptedRouteCount 設定されたルート数
	 */
	public void setAcceptedRouteCount(Integer acceptedRouteCount) {
		this.acceptedRouteCount = acceptedRouteCount;
	}

	/**
	 * 設定されたルート数を設定し、自オブジェクトを返します。
	 *
	 * @param acceptedRouteCount 設定されたルート数
	 * @return 自オブジェクト
	 */
	public VgwTelemetry withAcceptedRouteCount(Integer acceptedRouteCount) {
		setAcceptedRouteCount(acceptedRouteCount);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[outsideIpAddress=");
		builder.append(outsideIpAddress);
		builder.append(", status=");
		builder.append(status);
		builder.append(", lastStatusChange=");
		builder.append(lastStatusChange);
		builder.append(", statusMessage=");
		builder.append(statusMessage);
		builder.append(", acceptedRouteCount=");
		builder.append(acceptedRouteCount);
		builder.append("]");
		return builder.toString();
	}
}
