/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * Optionsクラス。<br />
 * このクラスはOptionsを格納します。
 *
 */
public class Options {

	private String staticRoutesOnly;

	private String niftyIpIpTunnel;

	/**
	 * staticRoutesOnlyを取得します。
	 *
	 * @return staticRoutesOnly
	 */
	@Query(name="StaticRoutesOnly")
	public String getStaticRoutesOnly() {
		return staticRoutesOnly;
	}

	/**
	 * staticRoutesOnlyを設定します。
	 *
	 * @param staticRoutesOnly
	 */
	public void setStaticRoutesOnly(String staticRoutesOnly) {
		this.staticRoutesOnly = staticRoutesOnly;
	}

	/**
	 * staticRoutesOnlyを設定し、自オブジェクトを返します。
	 *
	 * @param staticRoutesOnly
	 * @return 自オブジェクト
	 */
	public Options withStaticRoutesOnly(String staticRoutesOnly) {
		setStaticRoutesOnly(staticRoutesOnly);
		return this;
	}

	/**
	 * niftyIpIpTunnelを取得します。
	 *
	 * @return niftyIpIpTunnel
	 */
	@Query(name="NiftyIpIpTunnel")
	public String getNiftyIpIpTunnel() {
		return niftyIpIpTunnel;
	}

	/**
	 * niftyIpIpTunnelを設定します。
	 *
	 * @param niftyIpIpTunnel
	 */
	public void setNiftyIpIpTunnel(String niftyIpIpTunnel) {
		this.niftyIpIpTunnel = niftyIpIpTunnel;
	}

	/**
	 * niftyIpIpTunnelを設定し、自オブジェクトを返します。
	 *
	 * @param niftyIpIpTunnel
	 * @return 自オブジェクト
	 */
	public Options withNiftyIpIpTunnel(String niftyIpIpTunnel) {
		setNiftyIpIpTunnel(niftyIpIpTunnel);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[staticRoutesOnly=");
		builder.append(staticRoutesOnly);
		builder.append(", niftyIpIpTunnel=");
		builder.append(niftyIpIpTunnel);
		builder.append("]");
		return builder.toString();
	}
}
