/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * トンネル情報クラス。<br />
 * このクラスはトンネル情報を格納します。
 *
 */
public class NiftyTunnel {

	/** トンネルタイプ */
	private String type;

	/** トンネルモード */
	private String mode;

	/** カプセル化 */
	private String encapsulation;

	/** VPNゲートウェイ側トンネルID */
	private String tunnelId;

	/** カスタマーゲートウェイ側トンネルID */
	private String peerTunnelId;

	/** VPNゲートウェイ側セッションID */
	private String sessionId;

	/** カスタマーゲートウェイ側セッションID */
	private String peerSessionId;

	/** 送信元ポート（VPNゲートウェイ側ポート） */
	private String sourcePort;

	/** 送信先ポート（カスタマーゲートウェイ側ポート） */
	private String destinationPort;

	/**
	 * トンネルタイプを取得します。
	 *
	 * @return トンネルタイプ
	 */
	@Query(name="Type")
	public String getType() {
		return type;
	}

	/**
	 * トンネルタイプを設定します。
	 *
	 * @param type トンネルタイプ
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * トンネルタイプを設定し、自オブジェクトを返します。
	 *
	 * @param type トンネルタイプ
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * トンネルモードを取得します。
	 *
	 * @return トンネルモード
	 */
	@Query(name="Mode")
	public String getMode() {
		return mode;
	}

	/**
	 * トンネルモードを設定します。
	 *
	 * @param mode トンネルモード
	 */
	public void setMode(String mode) {
		this.mode = mode;
	}

	/**
	 * トンネルモードを設定し、自オブジェクトを返します。
	 *
	 * @param mode トンネルモード
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withMode(String mode) {
		setMode(mode);
		return this;
	}

	/**
	 * カプセル化を取得します。
	 *
	 * @return カプセル化
	 */
	@Query(name="Encapsulation")
	public String getEncapsulation() {
		return encapsulation;
	}

	/**
	 * カプセル化を設定します。
	 *
	 * @param encapsulation カプセル化
	 */
	public void setEncapsulation(String encapsulation) {
		this.encapsulation = encapsulation;
	}

	/**
	 * カプセル化を設定し、自オブジェクトを返します。
	 *
	 * @param encapsulation カプセル化
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withEncapsulation(String encapsulation) {
		setEncapsulation(encapsulation);
		return this;
	}

	/**
	 * VPNゲートウェイ側トンネルIDを取得します。
	 *
	 * @return VPNゲートウェイ側トンネルID
	 */
	@Query(name="TunnelId")
	public String getTunnelId() {
		return tunnelId;
	}

	/**
	 * VPNゲートウェイ側トンネルIDを設定します。
	 *
	 * @param tunnelId VPNゲートウェイ側トンネルID
	 */
	public void setTunnelId(String tunnelId) {
		this.tunnelId = tunnelId;
	}

	/**
	 * VPNゲートウェイ側トンネルIDを設定し、自オブジェクトを返します。
	 *
	 * @param tunnelId VPNゲートウェイ側トンネルID
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withTunnelId(String tunnelId) {
		setTunnelId(tunnelId);
		return this;
	}

	/**
	 * カスタマーゲートウェイ側トンネルIDを取得します。
	 *
	 * @return カスタマーゲートウェイ側トンネルID
	 */
	@Query(name="PeerTunnelId")
	public String getPeerTunnelId() {
		return peerTunnelId;
	}

	/**
	 * カスタマーゲートウェイ側トンネルIDを設定します。
	 *
	 * @param peerTunnelId カスタマーゲートウェイ側トンネルID
	 */
	public void setPeerTunnelId(String peerTunnelId) {
		this.peerTunnelId = peerTunnelId;
	}

	/**
	 * カスタマーゲートウェイ側トンネルIDを設定し、自オブジェクトを返します。
	 *
	 * @param peerTunnelId カスタマーゲートウェイ側トンネルID
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withPeerTunnelId(String peerTunnelId) {
		setPeerTunnelId(peerTunnelId);
		return this;
	}

	/**
	 * VPNゲートウェイ側セッションIDを取得します。
	 *
	 * @return VPNゲートウェイ側セッションID
	 */
	@Query(name="SessionId")
	public String getSessionId() {
		return sessionId;
	}

	/**
	 * VPNゲートウェイ側セッションIDを設定します。
	 *
	 * @param sessionId VPNゲートウェイ側セッションID
	 */
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	/**
	 * VPNゲートウェイ側セッションIDを設定し、自オブジェクトを返します。
	 *
	 * @param sessionId VPNゲートウェイ側セッションID
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withSessionId(String sessionId) {
		setSessionId(sessionId);
		return this;
	}

	/**
	 * カスタマーゲートウェイ側セッションIDを取得します。
	 *
	 * @return カスタマーゲートウェイ側セッションID
	 */
	@Query(name="PeerSessionId")
	public String getPeerSessionId() {
		return peerSessionId;
	}

	/**
	 * カスタマーゲートウェイ側セッションIDを設定します。
	 *
	 * @param peerSessionId カスタマーゲートウェイ側セッションID
	 */
	public void setPeerSessionId(String peerSessionId) {
		this.peerSessionId = peerSessionId;
	}

	/**
	 * カスタマーゲートウェイ側セッションIDを設定し、自オブジェクトを返します。
	 *
	 * @param peerSessionId カスタマーゲートウェイ側セッションID
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withPeerSessionId(String peerSessionId) {
		setPeerSessionId(peerSessionId);
		return this;
	}

	/**
	 * 送信元ポート（VPNゲートウェイ側ポート）を取得します。
	 *
	 * @return 送信元ポート（VPNゲートウェイ側ポート）
	 */
	@Query(name="SourcePort")
	public String getSourcePort() {
		return sourcePort;
	}

	/**
	 * 送信元ポート（VPNゲートウェイ側ポート）を設定します。
	 *
	 * @param sourcePort 送信元ポート（VPNゲートウェイ側ポート）
	 */
	public void setSourcePort(String sourcePort) {
		this.sourcePort = sourcePort;
	}

	/**
	 * 送信元ポート（VPNゲートウェイ側ポート）を設定し、自オブジェクトを返します。
	 *
	 * @param sourcePort 送信元ポート（VPNゲートウェイ側ポート）
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withSourcePort(String sourcePort) {
		setSourcePort(sourcePort);
		return this;
	}

	/**
	 * 送信先ポート（カスタマーゲートウェイ側ポート）を取得します。
	 *
	 * @return 送信先ポート（カスタマーゲートウェイ側ポート）
	 */
	@Query(name="DestinationPort")
	public String getDestinationPort() {
		return destinationPort;
	}

	/**
	 * 送信先ポート（カスタマーゲートウェイ側ポート）を設定します。
	 *
	 * @param destinationPort 送信先ポート（カスタマーゲートウェイ側ポート）
	 */
	public void setDestinationPort(String destinationPort) {
		this.destinationPort = destinationPort;
	}

	/**
	 * 送信先ポート（カスタマーゲートウェイ側ポート）を設定し、自オブジェクトを返します。
	 *
	 * @param destinationPort 送信先ポート（カスタマーゲートウェイ側ポート）
	 * @return 自オブジェクト
	 */
	public NiftyTunnel withDestinationPort(String destinationPort) {
		setDestinationPort(destinationPort);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[type=");
		builder.append(type);
		builder.append(", mode=");
		builder.append(mode);
		builder.append(", encapsulation=");
		builder.append(encapsulation);
		builder.append(", tunnelId=");
		builder.append(tunnelId);
		builder.append(", peerTunnelId=");
		builder.append(peerTunnelId);
		builder.append(", sessionId=");
		builder.append(sessionId);
		builder.append(", peerSessionId=");
		builder.append(peerSessionId);
		builder.append(", sourcePort=");
		builder.append(sourcePort);
		builder.append(", destinationPort=");
		builder.append(destinationPort);
		builder.append("]");
		return builder.toString();
	}
}
