/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyRemoteVpnクラス。<br />
 * このクラスはNiftyRemoteVpnを格納します。
 *
 */
public class NiftyRemoteVpn {

	private String accountName;

	private String password;

	/**
	 * accountNameを取得します。
	 *
	 * @return accountName
	 */
	@Query(name="AccountName")
	public String getAccountName() {
		return accountName;
	}

	/**
	 * accountNameを設定します。
	 *
	 * @param accountName
	 */
	public void setAccountName(String accountName) {
		this.accountName = accountName;
	}

	/**
	 * accountNameを設定し、自オブジェクトを返します。
	 *
	 * @param accountName
	 * @return 自オブジェクト
	 */
	public NiftyRemoteVpn withAccountName(String accountName) {
		setAccountName(accountName);
		return this;
	}

	/**
	 * passwordを取得します。
	 *
	 * @return password
	 */
	@Query(name="Password")
	public String getPassword() {
		return password;
	}

	/**
	 * passwordを設定します。
	 *
	 * @param password
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * passwordを設定し、自オブジェクトを返します。
	 *
	 * @param password
	 * @return 自オブジェクト
	 */
	public NiftyRemoteVpn withPassword(String password) {
		setPassword(password);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[accountName=");
		builder.append(accountName);
		builder.append(", password=");
		builder.append(password);
		builder.append("]");
		return builder.toString();
	}
}
