/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * 設定情報クラス。<br />
 * このクラスは設定情報を格納します。
 *
 */
public class NiftyIpsecConfiguration {

	/** 暗号化アルゴリズム */
	private String encryptionAlgorithm;

	/** 認証アルゴリズム */
	private String hashingAlgorithm;

	/** MTUサイズ */
	private String mtu;

	/** 事前共有鍵 */
	private String preSharedKey;

	/** IKEプロトコル */
	private String internetKeyExchange;

	/**
	 * 暗号化アルゴリズムを取得します。
	 *
	 * @return 暗号化アルゴリズム
	 */
	@Query(name="NiftyIpsecConfiguration.EncryptionAlgorithm")
	public String getEncryptionAlgorithm() {
		return encryptionAlgorithm;
	}

	/**
	 * 暗号化アルゴリズムを設定します。
	 *
	 * @param encryptionAlgorithm 暗号化アルゴリズム
	 */
	public void setEncryptionAlgorithm(String encryptionAlgorithm) {
		this.encryptionAlgorithm = encryptionAlgorithm;
	}

	/**
	 * 暗号化アルゴリズムを設定し、自オブジェクトを返します。
	 *
	 * @param encryptionAlgorithm 暗号化アルゴリズム
	 * @return 自オブジェクト
	 */
	public NiftyIpsecConfiguration withEncryptionAlgorithm(String encryptionAlgorithm) {
		setEncryptionAlgorithm(encryptionAlgorithm);
		return this;
	}

	/**
	 * 認証アルゴリズムを取得します。
	 *
	 * @return 認証アルゴリズム
	 */
	@Query(name="NiftyIpsecConfiguration.HashAlgorithm")
	public String getHashingAlgorithm() {
		return hashingAlgorithm;
	}

	/**
	 * 認証アルゴリズムを設定します。
	 *
	 * @param hashingAlgorithm 認証アルゴリズム
	 */
	public void setHashingAlgorithm(String hashingAlgorithm) {
		this.hashingAlgorithm = hashingAlgorithm;
	}

	/**
	 * 認証アルゴリズムを設定し、自オブジェクトを返します。
	 *
	 * @param hashingAlgorithm 認証アルゴリズム
	 * @return 自オブジェクト
	 */
	public NiftyIpsecConfiguration withHashingAlgorithm(String hashingAlgorithm) {
		setHashingAlgorithm(hashingAlgorithm);
		return this;
	}

	/**
	 * MTUサイズを取得します。
	 *
	 * @return MTUサイズ
	 */
	@Query(name="NiftyVpnConnectionMtu")
	public String getMtu() {
		return mtu;
	}

	/**
	 * MTUサイズを設定します。
	 *
	 * @param mtu MTUサイズ
	 */
	public void setMtu(String mtu) {
		this.mtu = mtu;
	}

	/**
	 * MTUサイズを設定し、自オブジェクトを返します。
	 *
	 * @param mtu MTUサイズ
	 * @return 自オブジェクト
	 */
	public NiftyIpsecConfiguration withMtu(String mtu) {
		setMtu(mtu);
		return this;
	}

	/**
	 * 事前共有鍵を取得します。
	 *
	 * @return 事前共有鍵
	 */
	@Query(name="NiftyIpsecConfiguration.PreSharedKey")
	public String getPreSharedKey() {
		return preSharedKey;
	}

	/**
	 * 事前共有鍵を設定します。
	 *
	 * @param preSharedKey 事前共有鍵
	 */
	public void setPreSharedKey(String preSharedKey) {
		this.preSharedKey = preSharedKey;
	}

	/**
	 * 事前共有鍵を設定し、自オブジェクトを返します。
	 *
	 * @param preSharedKey 事前共有鍵
	 * @return 自オブジェクト
	 */
	public NiftyIpsecConfiguration withPreSharedKey(String preSharedKey) {
		setPreSharedKey(preSharedKey);
		return this;
	}

	/**
	 * IKEプロトコルを取得します。
	 *
	 * @return IKEプロトコル
	 */
	@Query(name="NiftyIpsecConfiguration.InternetKeyExchange")
	public String getInternetKeyExchange() {
		return internetKeyExchange;
	}

	/**
	 * IKEプロトコルを設定します。
	 *
	 * @param internetKeyExchange IKEプロトコル
	 */
	public void setInternetKeyExchange(String internetKeyExchange) {
		this.internetKeyExchange = internetKeyExchange;
	}

	/**
	 * IKEプロトコルを設定し、自オブジェクトを返します。
	 *
	 * @param internetKeyExchange IKEプロトコル
	 * @return 自オブジェクト
	 */
	public NiftyIpsecConfiguration withInternetKeyExchange(String internetKeyExchange) {
		setInternetKeyExchange(internetKeyExchange);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[encryptionAlgorithm=");
		builder.append(encryptionAlgorithm);
		builder.append(", hashingAlgorithm=");
		builder.append(hashingAlgorithm);
		builder.append(", mtu=");
		builder.append(mtu);
		builder.append(", preSharedKey=");
		builder.append(preSharedKey);
		builder.append(", internetKeyExchange=");
		builder.append(internetKeyExchange);
		builder.append("]");
		return builder.toString();
	}
}
