/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.vpnconnection.model.transform.DescribeVpnConnectionsResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * DescribeVpnConnections処理結果クラス。<br />
 * このクラスはDescribeVpnConnectionsのレスポンスを格納します。
 */
@XStreamAlias("DescribeVpnConnectionsResponse")
@XStreamConverter(DescribeVpnConnectionsResultConverter.class)
public class DescribeVpnConnectionsResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** VPNコネクション情報リスト */
	private List<VpnConnection> vpnConnections;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public DescribeVpnConnectionsResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * VPNコネクション情報リストを取得します。
	 *
	 * @return VPNコネクション情報リスト
	 */
	public List<VpnConnection> getVpnConnections() {
		return vpnConnections;
	}

	/**
	 * VPNコネクション情報リストを設定します。
	 *
	 * @param vpnConnections VPNコネクション情報リスト
	 */
	public void setVpnConnections(List<VpnConnection> vpnConnections) {
		this.vpnConnections = vpnConnections;
	}

	/**
	 * VPNコネクション情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param vpnConnections VPNコネクション情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeVpnConnectionsResult withVpnConnections(VpnConnection ... vpnConnections) {
		if (this.vpnConnections == null) this.vpnConnections = new ArrayList<VpnConnection>();
		for (VpnConnection vpnConnection : vpnConnections) {
			getVpnConnections().add(vpnConnection);
		}
		return this;
	}

	/**
	 * VPNコネクション情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param vpnConnections VPNコネクション情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeVpnConnectionsResult withVpnConnections(Collection<VpnConnection> vpnConnections) {
		if (this.vpnConnections == null) this.vpnConnections = new ArrayList<VpnConnection>();
		if (vpnConnections != null) {
			getVpnConnections().addAll(vpnConnections);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", vpnConnections=");
		builder.append(vpnConnections);
		builder.append("]");
		return builder.toString();
	}
}
