/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DeleteVpnConnectionリクエストクラス。<br />
 * このクラスはDeleteVpnConnectionへのリクエストを構築します。
 *
 */
@Action("DeleteVpnConnection")
public class DeleteVpnConnectionRequest implements Request {

	/** VPNコネクションユニークID */
	private String vpnConnectionId;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * デフォルトコンストラクタ。
	 */
	public DeleteVpnConnectionRequest() {
	}

	/**
	 * VPNコネクションユニークIDを指定し、DeleteVpnConnectionRequestを構築します。
	 *
	 * @param vpnConnectionId VPNコネクションユニークID
	 */
	public DeleteVpnConnectionRequest(String vpnConnectionId) {
		this.vpnConnectionId = vpnConnectionId;
	}

	/**
	 * VPNコネクションユニークIDを取得します。
	 *
	 * @return VPNコネクションユニークID
	 */
	@Query(name="VpnConnectionId", require=true)
	public String getVpnConnectionId() {
		return vpnConnectionId;
	}

	/**
	 * VPNコネクションユニークIDを設定します。
	 *
	 * @param vpnConnectionId VPNコネクションユニークID
	 */
	public void setVpnConnectionId(String vpnConnectionId) {
		this.vpnConnectionId = vpnConnectionId;
	}

	/**
	 * VPNコネクションユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnConnectionId VPNコネクションユニークID
	 * @return 自オブジェクト
	 */
	public DeleteVpnConnectionRequest withVpnConnectionId(String vpnConnectionId) {
		setVpnConnectionId(vpnConnectionId);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public DeleteVpnConnectionRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnConnectionId=");
		builder.append(vpnConnectionId);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
