/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * CreateVpnConnectionリクエストクラス。<br />
 * このクラスはCreateVpnConnectionへのリクエストを構築します。
 *
 */
@Action("CreateVpnConnection")
public class CreateVpnConnectionRequest implements Request {

	/** VPNコネクションタイプ */
	private String type;

	/** VPNゲートウェイユニークID */
	private String vpnGatewayId;

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	/** カスタマーゲートウェイユニークID */
	private String customerGatewayId;

	/** カスタマーゲートウェイ名 */
	private String niftyCustomerGatewayName;

	private NiftyRemoteVpn niftyRemoteVpn;

	private Options options;

	/** トンネル情報 */
	private NiftyTunnel niftyTunnel;

	/** 設定情報 */
	private NiftyIpsecConfiguration niftyIpsecConfiguration;

	/** メモ */
	private String niftyVpnConnectionDescription;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * デフォルトコンストラクタ。
	 */
	public CreateVpnConnectionRequest() {
	}

	/**
	 * VPNコネクションタイプを指定し、CreateVpnConnectionRequestを構築します。
	 *
	 * @param type VPNコネクションタイプ
	 */
	public CreateVpnConnectionRequest(String type) {
		this.type = type;
	}

	/**
	 * VPNコネクションタイプを取得します。
	 *
	 * @return VPNコネクションタイプ
	 */
	@Query(name="Type", require=true)
	public String getType() {
		return type;
	}

	/**
	 * VPNコネクションタイプを設定します。
	 *
	 * @param type VPNコネクションタイプ
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * VPNコネクションタイプを設定し、自オブジェクトを返します。
	 *
	 * @param type VPNコネクションタイプ
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * VPNゲートウェイユニークIDを取得します。
	 *
	 * @return VPNゲートウェイユニークID
	 */
	@Query(name="VpnGatewayId")
	public String getVpnGatewayId() {
		return vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 */
	public void setVpnGatewayId(String vpnGatewayId) {
		this.vpnGatewayId = vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withVpnGatewayId(String vpnGatewayId) {
		setVpnGatewayId(vpnGatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	@Query(name="NiftyVpnGatewayName")
	public String getNiftyVpnGatewayName() {
		return niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
		this.niftyVpnGatewayName = niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * カスタマーゲートウェイユニークIDを取得します。
	 *
	 * @return カスタマーゲートウェイユニークID
	 */
	@Query(name="CustomerGatewayId")
	public String getCustomerGatewayId() {
		return customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 */
	public void setCustomerGatewayId(String customerGatewayId) {
		this.customerGatewayId = customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withCustomerGatewayId(String customerGatewayId) {
		setCustomerGatewayId(customerGatewayId);
		return this;
	}

	/**
	 * カスタマーゲートウェイ名を取得します。
	 *
	 * @return カスタマーゲートウェイ名
	 */
	@Query(name="NiftyCustomerGatewayName")
	public String getNiftyCustomerGatewayName() {
		return niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 */
	public void setNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		this.niftyCustomerGatewayName = niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		setNiftyCustomerGatewayName(niftyCustomerGatewayName);
		return this;
	}

	/**
	 * niftyRemoteVpnを取得します。
	 *
	 * @return niftyRemoteVpn
	 */
	@Query(name="NiftyRemoteVpn")
	public NiftyRemoteVpn getNiftyRemoteVpn() {
		return niftyRemoteVpn;
	}

	/**
	 * niftyRemoteVpnを設定します。
	 *
	 * @param niftyRemoteVpn
	 */
	public void setNiftyRemoteVpn(NiftyRemoteVpn niftyRemoteVpn) {
		this.niftyRemoteVpn = niftyRemoteVpn;
	}

	/**
	 * niftyRemoteVpnを設定し、自オブジェクトを返します。
	 *
	 * @param niftyRemoteVpn
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withNiftyRemoteVpn(NiftyRemoteVpn niftyRemoteVpn) {
		setNiftyRemoteVpn(niftyRemoteVpn);
		return this;
	}

	/**
	 * optionsを取得します。
	 *
	 * @return options
	 */
	@Query(name="Options")
	public Options getOptions() {
		return options;
	}

	/**
	 * optionsを設定します。
	 *
	 * @param options
	 */
	public void setOptions(Options options) {
		this.options = options;
	}

	/**
	 * optionsを設定し、自オブジェクトを返します。
	 *
	 * @param options
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withOptions(Options options) {
		setOptions(options);
		return this;
	}

	/**
	 * トンネル情報を取得します。
	 *
	 * @return トンネル情報
	 */
	@Query(name="NiftyTunnel")
	public NiftyTunnel getNiftyTunnel() {
		return niftyTunnel;
	}

	/**
	 * トンネル情報を設定します。
	 *
	 * @param niftyTunnel トンネル情報
	 */
	public void setNiftyTunnel(NiftyTunnel niftyTunnel) {
		this.niftyTunnel = niftyTunnel;
	}

	/**
	 * トンネル情報を設定し、自オブジェクトを返します。
	 *
	 * @param niftyTunnel トンネル情報
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withNiftyTunnel(NiftyTunnel niftyTunnel) {
		setNiftyTunnel(niftyTunnel);
		return this;
	}

	/**
	 * 設定情報を取得します。
	 *
	 * @return 設定情報
	 */
	@Query(name="")
	public NiftyIpsecConfiguration getNiftyIpsecConfiguration() {
		return niftyIpsecConfiguration;
	}

	/**
	 * 設定情報を設定します。
	 *
	 * @param niftyIpsecConfiguration 設定情報
	 */
	public void setNiftyIpsecConfiguration(NiftyIpsecConfiguration niftyIpsecConfiguration) {
		this.niftyIpsecConfiguration = niftyIpsecConfiguration;
	}

	/**
	 * 設定情報を設定し、自オブジェクトを返します。
	 *
	 * @param niftyIpsecConfiguration 設定情報
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withNiftyIpsecConfiguration(NiftyIpsecConfiguration niftyIpsecConfiguration) {
		setNiftyIpsecConfiguration(niftyIpsecConfiguration);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	@Query(name="NiftyVpnConnectionDescription")
	public String getNiftyVpnConnectionDescription() {
		return niftyVpnConnectionDescription;
	}

	/**
	 * メモを設定します。
	 *
	 * @param niftyVpnConnectionDescription メモ
	 */
	public void setNiftyVpnConnectionDescription(String niftyVpnConnectionDescription) {
		this.niftyVpnConnectionDescription = niftyVpnConnectionDescription;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnConnectionDescription メモ
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withNiftyVpnConnectionDescription(String niftyVpnConnectionDescription) {
		setNiftyVpnConnectionDescription(niftyVpnConnectionDescription);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public CreateVpnConnectionRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[type=");
		builder.append(type);
		builder.append(", vpnGatewayId=");
		builder.append(vpnGatewayId);
		builder.append(", niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", customerGatewayId=");
		builder.append(customerGatewayId);
		builder.append(", niftyCustomerGatewayName=");
		builder.append(niftyCustomerGatewayName);
		builder.append(", niftyRemoteVpn=");
		builder.append(niftyRemoteVpn);
		builder.append(", options=");
		builder.append(options);
		builder.append(", niftyTunnel=");
		builder.append(niftyTunnel);
		builder.append(", niftyIpsecConfiguration=");
		builder.append(niftyIpsecConfiguration);
		builder.append(", niftyVpnConnectionDescription=");
		builder.append(niftyVpnConnectionDescription);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
