/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.vpnconnection;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.vpnconnection.model.CreateVpnConnectionRequest;
import com.nifty.cloud.sdk.vpnconnection.model.CreateVpnConnectionResult;
import com.nifty.cloud.sdk.vpnconnection.model.DeleteVpnConnectionRequest;
import com.nifty.cloud.sdk.vpnconnection.model.DeleteVpnConnectionResult;
import com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsRequest;
import com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * VPNコネクションカテゴリ クライアント。<br />
 * VPNコネクション カテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public class NiftyVpnConnectionClient extends BaseClient implements NiftyVpnConnection {

	/**
	 * 認証情報を指定し、VPNコネクションカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyVpnConnectionClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、VPNコネクションカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyVpnConnectionClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpnconnection.NiftyVpnConnection#createVpnConnection(com.nifty.cloud.sdk.vpnconnection.model.CreateVpnConnectionRequest)
	 */
	@Override
	public CreateVpnConnectionResult createVpnConnection(CreateVpnConnectionRequest request) {
		return (CreateVpnConnectionResult) client.execute(request, CreateVpnConnectionResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpnconnection.NiftyVpnConnection#deleteVpnConnection(com.nifty.cloud.sdk.vpnconnection.model.DeleteVpnConnectionRequest)
	 */
	@Override
	public DeleteVpnConnectionResult deleteVpnConnection(DeleteVpnConnectionRequest request) {
		return (DeleteVpnConnectionResult) client.execute(request, DeleteVpnConnectionResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.vpnconnection.NiftyVpnConnection#describeVpnConnections(com.nifty.cloud.sdk.vpnconnection.model.DescribeVpnConnectionsRequest)
	 */
	@Override
	public DescribeVpnConnectionsResult describeVpnConnections(DescribeVpnConnectionsRequest request) {
		return (DescribeVpnConnectionsResult) client.execute(request, DescribeVpnConnectionsResult.class);
	}
}